/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.validation.WoodstoxValidationImpl;

public class StaxSchemaValidationInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxSchemaValidationInInterceptor.class);

    public StaxSchemaValidationInInterceptor() {
        super("read");
        this.addBefore(StartBodyInterceptor.class.getName());
        this.addAfter(ReadHeadersInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        this.setSchemaInMessage(message, xmlReader);
    }

    private void setSchemaInMessage(Message message, XMLStreamReader reader) {
        if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.IN, (Message)message)) {
            try {
                WoodstoxValidationImpl mgr = new WoodstoxValidationImpl();
                if (mgr.canValidate()) {
                    mgr.setupValidation(reader, message.getExchange().getEndpoint(), (ServiceInfo)message.getExchange().getService().getServiceInfos().get(0));
                }
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "Problem initializing MSV validation", t);
            }
        }
    }
}

