/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CtrlToNCRInputStream
extends FilterInputStream {
    private final byte[] replacementBytes = new byte[]{38, 35, 48, 48, 59};
    private int replacementIndex = 100;

    public CtrlToNCRInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.replacementIndex < 5) {
            return this.replacementBytes[this.replacementIndex++];
        }
        int b = super.read();
        if (this.isNonHTLFCR_C0ControlCharacter(b)) {
            this.replacementIndex = 0;
            byte[] cnrBytes = CtrlToNCRInputStream.padInteger(b).getBytes();
            this.replacementBytes[2] = cnrBytes[0];
            this.replacementBytes[3] = cnrBytes[1];
            return this.replacementBytes[this.replacementIndex++];
        }
        return b;
    }

    public static String padInteger(int number) {
        String numberStr = String.valueOf(number);
        if (numberStr.length() == 1) {
            return "0" + numberStr;
        }
        return numberStr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead;
        for (totalRead = 0; totalRead < len; ++totalRead) {
            int readByte = this.read();
            if (readByte == -1) {
                return totalRead == 0 ? -1 : totalRead;
            }
            b[off + totalRead] = (byte)readByte;
        }
        return totalRead;
    }

    private boolean isNonHTLFCR_C0ControlCharacter(int c) {
        return c > 0 && c < 32 && c != 13 && c != 10 && c != 9;
    }
}

