/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;
import org.mule.soapkit.soap.util.DataHandlerUtils;

public class CopyAttachmentOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public CopyAttachmentOutInterceptor() {
        super("setup");
    }

    public void handleMessage(Message message) throws Fault {
        SoapResponse response = (SoapResponse)Cast.cast(message.getExchange().get((Object)"mule.soap.server.response"));
        if (response == null) {
            return;
        }
        Map attachments = response.getAttachments();
        message.setAttachments(this.transformToCxfAttachments(attachments).values());
    }

    private Map<String, Attachment> transformToCxfAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            try {
                builder.put(name, (Object)new AttachmentImpl(name, DataHandlerUtils.toDataHandler(name, value.getContent(), MediaType.parse((String)value.getContentType()))));
            }
            catch (IOException e) {
                throw new BadResponseException(String.format("Error while preparing attachment [%s] for download", name), (Throwable)e);
            }
        });
        return builder.build();
    }
}

