/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.databinding.stax.StaxDataBindingInterceptor;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl.service.factory.ReflectionServiceFactoryBean;
import org.jetbrains.annotations.NotNull;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.soap.api.SoapVersion;
import org.mule.soapkit.soap.api.server.SoapServer;
import org.mule.soapkit.soap.api.server.SoapServerConfiguration;
import org.mule.soapkit.soap.api.server.SoapServerFactory;
import org.mule.soapkit.soap.server.ProxyService;
import org.mule.soapkit.soap.server.ProxyServiceFactoryBean;
import org.mule.soapkit.soap.server.SoapCxfInvoker;
import org.mule.soapkit.soap.server.SoapCxfServer;
import org.mule.soapkit.soap.server.interceptor.AttachmentOutputInterceptor;
import org.mule.soapkit.soap.server.interceptor.CopyAttachmentInInterceptor;
import org.mule.soapkit.soap.server.interceptor.CopyAttachmentOutInterceptor;
import org.mule.soapkit.soap.server.interceptor.CustomNamespacesInterceptor;
import org.mule.soapkit.soap.server.interceptor.InputSoapHeadersInterceptor;
import org.mule.soapkit.soap.server.interceptor.OutputPayloadInterceptor;
import org.mule.soapkit.soap.server.interceptor.OutputSoapHeadersInterceptor;
import org.mule.soapkit.soap.server.interceptor.RemoveCheckClosingTagsInterceptor;
import org.mule.soapkit.soap.server.interceptor.SeekBopInterceptor;
import org.mule.soapkit.soap.server.interceptor.StaxSchemaValidationInInterceptor;
import org.mule.soapkit.soap.server.interceptor.WriteXmlDeclarationOutInterceptor;
import org.mule.soapkit.soap.server.transport.ProxyTransport;

public class SoapCxfServerFactory
implements SoapServerFactory {
    public static final String MULE_SOAPKIT_HEADER_VALIDATION = "mule.soapkit.headerValidation";
    private final Bus bus = (Bus)ClassUtils.withContextClassLoader((ClassLoader)SoapCxfServerFactory.class.getClassLoader(), () -> new SpringBusFactory().createBus((String)null, true));

    public SoapCxfServerFactory() {
        ProxyTransport transport = new ProxyTransport();
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/local", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/http/configuration", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://www.w3.org/2003/05/soap/bindings/HTTP/", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/jms", (DestinationFactory)transport);
        dfm.registerDestinationFactory("http://mule.codehaus.org/cxf", (DestinationFactory)transport);
        ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/local", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/http/configuration", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/soap/http/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/http/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://www.w3.org/2003/05/soap/bindings/HTTP/", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/bindings/xformat", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://cxf.apache.org/transports/jms", (ConduitInitiator)transport);
        extension.registerConduitInitiator("http://mule.codehaus.org/cxf", (ConduitInitiator)transport);
        try {
            extension.getConduitInitiator("http://schemas.xmlsoap.org/soap/http");
        }
        catch (BusException busException) {
            // empty catch block
        }
    }

    @Override
    public SoapServer create(SoapServerConfiguration config) throws ConnectionException {
        return this.createSoapCxfServer(config);
    }

    private SoapCxfServer createSoapCxfServer(SoapServerConfiguration config) {
        Server server = this.createCxfServer(config);
        return SoapCxfServer.create(server, config.getPortModel(), config.isMtomEnabled(), config.isValidationEnabled(), config.getValidationErrorLevel());
    }

    @NotNull
    private Server createCxfServer(SoapServerConfiguration config) {
        ServerFactoryBean factory = new ServerFactoryBean();
        factory.setBus(this.bus);
        factory.setDataBinding((DataBinding)new StaxDataBinding());
        factory.getFeatures().add(new StaxDataBindingFeature());
        SoapVersion soapVersion = config.getVersion();
        if (soapVersion != null) {
            factory.setBindingId(this.getBindingIdForSoapVersion(soapVersion));
        }
        factory.setServiceClass(ProxyService.class);
        ProxyServiceFactoryBean serviceFactory = new ProxyServiceFactoryBean(config);
        QName service = new QName(config.getNamespace(), config.getService());
        serviceFactory.setServiceName(service);
        factory.setServiceFactory((ReflectionServiceFactoryBean)serviceFactory);
        factory.getInInterceptors().add(new InputSoapHeadersInterceptor());
        factory.getInInterceptors().add(new CopyAttachmentInInterceptor());
        factory.getOutInterceptors().add(new OutputSoapHeadersInterceptor());
        factory.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
        factory.getOutInterceptors().add(new OutputPayloadInterceptor());
        factory.getOutInterceptors().add(new WriteXmlDeclarationOutInterceptor(config.isResponseXMLDeclarationEnabled()));
        factory.getOutInterceptors().add(new CustomNamespacesInterceptor(config.getNamespacePrefixes()));
        SeekBopInterceptor seekBopInterceptor = new SeekBopInterceptor();
        seekBopInterceptor.addBefore(StaxDataBindingInterceptor.class.getName());
        factory.getInInterceptors().add(seekBopInterceptor);
        if (config.isPayloadBody() && config.isValidationEnabled()) {
            if (SoapCxfServerFactory.isHeaderValidationEnabled()) {
                factory.getInInterceptors().add(new SoapHeaderInterceptor());
            }
            factory.getInInterceptors().add(new StaxSchemaValidationInInterceptor());
            factory.getInInterceptors().add(new RemoveCheckClosingTagsInterceptor());
        }
        factory.setInvoker((Invoker)new SoapCxfInvoker());
        Server server = factory.create();
        Binding binding = server.getEndpoint().getBinding();
        SoapCxfServerFactory.removeInterceptor(binding.getOutInterceptors(), AttachmentOutInterceptor.class);
        SoapCxfServerFactory.removeInterceptor(binding.getOutFaultInterceptors(), AttachmentOutInterceptor.class);
        binding.getOutInterceptors().add(new AttachmentOutputInterceptor());
        binding.getOutFaultInterceptors().add(new AttachmentOutputInterceptor());
        return server;
    }

    private static void removeInterceptor(List<Interceptor<? extends Message>> interceptors, Class<?> clazz) {
        for (Interceptor<? extends Message> i : interceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getClass().equals(clazz)) continue;
            interceptors.remove(p);
            break;
        }
    }

    private String getBindingIdForSoapVersion(SoapVersion soapVersion) {
        return soapVersion.getNumber().equals("1.2") ? "http://schemas.xmlsoap.org/wsdl/soap12/" : "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    private static boolean isHeaderValidationEnabled() {
        String headerValiationEnabled = System.getProperty(MULE_SOAPKIT_HEADER_VALIDATION);
        if (headerValiationEnabled == null) {
            return true;
        }
        return Boolean.parseBoolean(headerValiationEnabled);
    }
}

