/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.util;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.soapkit.soap.util.XmlTransformationException;
import org.mule.soapkit.soap.xml.stax.StaxSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlTransformationUtils {
    private static final XMLInputFactory XML_INPUT_FACTORY = XmlTransformationUtils.getXmlInputFactory();
    private static final TransformerFactory TRANSFORMER_FACTORY = XMLSecureFactories.createDefault().getTransformerFactory();

    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory xmlInputFactory = WstxInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory;
    }

    public static Element stringToDomElement(String xml) throws XmlTransformationException {
        try {
            DocumentBuilder db = XMLSecureFactories.createDefault().getDocumentBuilderFactory().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            return db.parse(is).getDocumentElement();
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform xml string to Dom Element", e);
        }
    }

    public static String nodeToString(Node node) throws XmlTransformationException {
        try {
            StringWriter writer = new StringWriter();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform Node to String", e);
        }
    }

    public static XMLStreamReader inputStreamToXmlStreamReader(InputStream inputStream, MediaType mediaType) throws XmlTransformationException {
        try {
            Charset charset = mediaType.getCharset().orElse(Charset.defaultCharset());
            return XML_INPUT_FACTORY.createXMLStreamReader(inputStream, charset.name());
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform xml to XmlStreamReader", e);
        }
    }

    public static InputStream xmlStreamReaderToInputStream(XMLStreamReader xmlStreamReader) throws XmlTransformationException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StaxSource source = new StaxSource(xmlStreamReader);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", xmlStreamReader.getEncoding());
            transformer.transform((Source)((Object)source), result);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerException e) {
            throw new XmlTransformationException("Error transforming reader to DOM document", e);
        }
    }
}

