/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.mule.soapkit.soap.server.transport.ProxyDestinationFactory;

public class ProxyTransport
extends LocalTransportFactory {
    private ConcurrentMap<String, Destination> destinations = new ConcurrentHashMap<String, Destination>();

    public ProxyTransport() {
        this.setUriPrefixes(new HashSet<String>(Arrays.asList("http", "https", "local")));
    }

    public Destination getDestination(EndpointInfo ei, Bus bus) throws IOException {
        return this.getDestination(ei, this.createReference(ei));
    }

    private EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        endpoint.setAddress(address);
        return endpoint;
    }

    void remove(ProxyDestinationFactory destination) {
        this.destinations.remove(destination.getAddress().getAddress().getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getDestination(EndpointInfo ei, EndpointReferenceType reference) throws IOException {
        String uri = reference.getAddress().getValue();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        ProxyTransport proxyTransport = this;
        synchronized (proxyTransport) {
            return this.destinations.computeIfAbsent(uri, k -> this.createDestination(ei, reference));
        }
    }

    private Destination createDestination(EndpointInfo ei, EndpointReferenceType reference) {
        return new ProxyDestinationFactory(this, reference, ei);
    }
}

