/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.scripting.listeners;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingArtifactLifecycleListener
implements ArtifactLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingArtifactLifecycleListener.class);
    private static final String GROOVY_CLASS_INFO = "org.codehaus.groovy.reflection.ClassInfo";
    private static final String GROOVY_INVOKER_HELPER = "org.codehaus.groovy.runtime.InvokerHelper";
    private static final String LOGGER_ABSTRACT_MANAGER = "org.apache.logging.log4j.core.appender.AbstractManager";
    private static final String LOGGER_STREAM_MANAGER = "org.apache.logging.log4j.core.appender.OutputStreamManager";
    private static final String GROOVY_SCRIPT_ENGINE_FACTORY = "org.codehaus.groovy.jsr223.GroovyScriptEngineFactory";
    private static final String LOGGER_CONFIGURATION = "org.apache.logging.log4j.core.config.Configuration";

    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        LOGGER.debug("Running onArtifactDisposal method on {}", (Object)this.getClass().getName());
        ClassLoader classLoader = artifactDisposalContext.getArtifactClassLoader();
        this.unregisterAllClassesFromInvokerHelper(classLoader);
        if (ScriptingArtifactLifecycleListener.getJavaVersion().floatValue() <= 11.0f) {
            this.cleanSpisEngines(classLoader);
        }
    }

    private void unregisterAllClassesFromInvokerHelper(ClassLoader classLoader) {
        LOGGER.debug("Unregistering all classes from invoker helper");
        try {
            Class<?> classInfoClass = classLoader.loadClass(GROOVY_CLASS_INFO);
            Method getAllClassInfoMethod = classInfoClass.getMethod("getAllClassInfo", new Class[0]);
            Method getTheClassMethod = classInfoClass.getMethod("getTheClass", new Class[0]);
            Class<?> invokerHelperClass = classLoader.loadClass(GROOVY_INVOKER_HELPER);
            Method removeClassMethod = invokerHelperClass.getMethod("removeClass", Class.class);
            Object classInfos = getAllClassInfoMethod.invoke(null, new Object[0]);
            if (classInfos instanceof Collection) {
                for (Object classInfo : (Collection)classInfos) {
                    Object clazz = null;
                    try {
                        clazz = getTheClassMethod.invoke(classInfo, new Object[0]);
                        removeClassMethod.invoke(null, clazz);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        String className = clazz instanceof Class ? ((Class)clazz).getName() : "Unknown";
                        LOGGER.warn("Could not remove the {} class from the Groovy's InvokerHelper", (Object)className, (Object)e);
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Error trying to remove the Groovy's InvokerHelper classes", (Throwable)e);
        }
    }

    @Deprecated
    private void cleanSpisEngines(ClassLoader classLoader) {
        LOGGER.debug("Cleaning Groovy engine from SPIS set");
        try {
            Class abstractManager = ClassUtils.loadClass((String)LOGGER_ABSTRACT_MANAGER, (ClassLoader)classLoader);
            HashMap abstractManagerHashMap = (HashMap)ScriptingArtifactLifecycleListener.getStaticFieldValue(abstractManager, "MAP", true);
            Class streamManagerClass = ClassUtils.loadClass((String)LOGGER_STREAM_MANAGER, (ClassLoader)classLoader);
            Object rfmInstance = null;
            for (Object manager : abstractManagerHashMap.values()) {
                if (!streamManagerClass.isInstance(manager)) continue;
                rfmInstance = manager;
                Object layout = ScriptingArtifactLifecycleListener.getFieldValue(rfmInstance, "layout", true);
                Object configuration = ScriptingArtifactLifecycleListener.getFieldValue(layout, "configuration", true);
                Class configurationClass = ClassUtils.loadClass((String)LOGGER_CONFIGURATION, (ClassLoader)classLoader);
                Method getScriptManagerMethod = configurationClass.getMethod("getScriptManager", new Class[0]);
                Object scriptManager = getScriptManagerMethod.invoke(configuration, new Object[0]);
                if (scriptManager == null) continue;
                this.cleanGroovyEngines(classLoader, scriptManager);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Error trying to unregister the Groovy's Scripting Engine", (Throwable)e);
        }
    }

    @Deprecated
    private void cleanGroovyEngines(ClassLoader classLoader, Object scriptManager) throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Object innerScriptManager = ScriptingArtifactLifecycleListener.getFieldValue(scriptManager, "manager", true);
        Iterable engineSpis = (Iterable)ScriptingArtifactLifecycleListener.getFieldValue(innerScriptManager, "engineSpis", true);
        Class groovy = ClassUtils.loadClass((String)GROOVY_SCRIPT_ENGINE_FACTORY, (ClassLoader)classLoader);
        Iterator engineSpisIterator = engineSpis.iterator();
        while (engineSpisIterator.hasNext()) {
            Object i = engineSpisIterator.next();
            if (!groovy.isInstance(i) || !i.getClass().getClassLoader().equals(groovy.getClassLoader())) continue;
            LOGGER.info("Removing Groovy factory from ScriptEngineManager SPIs set");
            engineSpisIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <T> T getStaticFieldValue(Class<?> targetClass, String fieldName, boolean recursive) throws NoSuchFieldException, IllegalAccessException {
        Field field = ScriptingArtifactLifecycleListener.getField(targetClass, fieldName, recursive);
        boolean isAccessible = field.isAccessible();
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalAccessException(String.format("The %s field of %s class is not static", fieldName, targetClass.getName()));
        }
        try {
            field.setAccessible(true);
            Object object = field.get(null);
            return (T)object;
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    @Deprecated
    private static Field getField(Class<?> targetClass, String fieldName, boolean recursive) throws NoSuchFieldException {
        Class<?> clazz = targetClass;
        while (!Object.class.equals(clazz)) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (!recursive) break;
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException(String.format("Could not find field '%s' in class %s", fieldName, targetClass.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static <T> T getFieldValue(Object target, String fieldName, boolean recursive) throws IllegalAccessException, NoSuchFieldException {
        Field f = ScriptingArtifactLifecycleListener.getField(target.getClass(), fieldName, recursive);
        boolean isAccessible = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(target);
            return (T)object;
        }
        finally {
            f.setAccessible(isAccessible);
        }
    }

    @Deprecated
    private static Float getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        LOGGER.info("Java version {}", (Object)version);
        return Float.valueOf(Float.parseFloat(version));
    }
}

