/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.scripting.component;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mule.plugin.scripting.errors.ScriptingErrors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String BINDING_LOG = "log";
    private static final String BINDING_RESULT = "result";
    private static final String REGISTRY = "registry";
    private static final String ECMA_SCRIPT_ENGINE = "ECMAScript";
    private static final String NASHORN_ENGINE = "Nashorn";
    private String engineName;
    private String scriptBody;
    private ComponentLocation location;
    @Inject
    private Registry registry;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;
    private ScriptEngineManager scriptEngineManager;

    public ScriptRunner(String engine, String code, ComponentLocation location) {
        this.engineName = engine;
        this.scriptBody = code;
        this.location = location;
    }

    public ScriptRunner() {
    }

    public void initialise() {
        block7: {
            this.scriptEngineManager = new ScriptEngineManager(Thread.currentThread().getContextClassLoader());
            this.scriptEngine = this.createScriptEngineByName(this.engineName);
            if (this.scriptEngine == null && ECMA_SCRIPT_ENGINE.equalsIgnoreCase(this.engineName)) {
                this.scriptEngine = this.createScriptEngineByName(NASHORN_ENGINE);
            }
            if (this.scriptEngine == null) {
                String message = "Scripting engine '" + this.engineName + "' not found.  Available engines are: " + this.listAvailableEngines();
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)message), (ErrorTypeDefinition)ScriptingErrors.UNKNOWN_ENGINE);
            }
            StringReader script = new StringReader(this.scriptBody);
            try {
                if (!(this.scriptEngine instanceof Compilable)) break block7;
                try {
                    this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
                }
                catch (ScriptException e) {
                    throw new ModuleException((ErrorTypeDefinition)ScriptingErrors.COMPILATION, (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)script);
            }
        }
    }

    public void populateDefaultBindings(Bindings bindings) {
        bindings.put(BINDING_LOG, (Object)LOGGER);
        bindings.put(BINDING_RESULT, (Object)null);
    }

    public void populateBindings(Bindings bindings, CoreEvent event, Map<String, Object> parameters, StreamingHelper streamingHelper) {
        for (Binding binding : BindingContextUtils.addEventBindings((Event)event, (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT).bindings()) {
            if (binding.identifier().equals("vars")) continue;
            Object resolvedValue = this.resolveCursors(binding.value().getValue(), streamingHelper);
            bindings.put(binding.identifier(), resolvedValue);
        }
        bindings.put("vars", (Object)Collections.unmodifiableMap((Map)this.resolveCursors(event.getVariables(), streamingHelper)));
        bindings.put("flow", (Object)this.location.getRootContainerName());
        bindings.put(REGISTRY, (Object)this.registry);
        bindings.putAll((Map<? extends String, ? extends Object>)parameters);
        this.populateDefaultBindings(bindings);
    }

    public void closeCursors(Bindings bindings) {
        bindings.forEach((k, v) -> this.closeCursor(TypedValue.unwrap((Object)v)));
    }

    private void closeCursor(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            map.forEach((k, v) -> this.closeCursor(TypedValue.unwrap((Object)v)));
        } else if (o instanceof Cursor) {
            try {
                ((Cursor)o).close();
            }
            catch (IOException e) {
                LOGGER.warn("Cannot close cursor", (Throwable)e);
            }
        }
    }

    public Object runScript(Bindings bindings) {
        Object result;
        try {
            result = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.scriptBody, bindings);
            if (result == null) {
                result = bindings.get(BINDING_RESULT);
            }
        }
        catch (Exception ex) {
            throw new ModuleException((ErrorTypeDefinition)ScriptingErrors.EXECUTION, (Throwable)ex);
        }
        return result;
    }

    protected ScriptEngine createScriptEngineByName(String name) {
        return this.scriptEngineManager.getEngineByName(name);
    }

    protected String listAvailableEngines() {
        List listsOfEngineNames = this.scriptEngineManager.getEngineFactories().stream().map(ScriptEngineFactory::getNames).collect(Collectors.toList());
        return listsOfEngineNames.stream().flatMap(Collection::stream).collect(Collectors.joining(", "));
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    private Object resolveCursors(Object value, StreamingHelper streamingHelper) {
        Object objectValue = TypedValue.unwrap((Object)value);
        if (objectValue instanceof Map) {
            return this.createResolvedMap((Map)objectValue, streamingHelper);
        }
        return streamingHelper.resolveCursor(objectValue);
    }

    private Map<String, Object> createResolvedMap(Map<String, Object> map, StreamingHelper streamingHelper) {
        HashMap resolvedMap = new HashMap();
        map.forEach((key, value) -> resolvedMap.put(key, TypedValue.unwrap((Object)value)));
        return streamingHelper.resolveCursors(resolvedMap, true);
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(String scriptBody) {
        this.scriptBody = scriptBody;
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ComponentLocation location) {
        this.location = location;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

