/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.scripting.operation;

import java.util.Map;
import javax.script.Bindings;
import org.mule.plugin.scripting.component.ScriptRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ScriptingOperationExecutor
implements ComponentExecutor<OperationModel> {
    private ScriptRunner scriptRunner;

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        try {
            if (this.scriptRunner == null) {
                String engine = (String)context.getParameter("engine");
                String code = (String)context.getParameter("code");
                this.scriptRunner = new ScriptRunner(engine, code, context.getComponentLocation());
                context.getMuleContext().getInjector().inject((Object)this.scriptRunner);
            }
            Map parameters = (Map)context.getParameter("parameters");
            Result<Object, Object> result = this.process(context.getEvent(), parameters);
            return Mono.justOrEmpty(result);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<Object, Object> process(CoreEvent event, Map<String, Object> parameters) throws MuleException {
        Bindings bindings = this.scriptRunner.getScriptEngine().createBindings();
        this.scriptRunner.populateBindings(bindings, event, parameters);
        try {
            Object result = this.scriptRunner.runScript(bindings);
            if (result instanceof Message) {
                CoreEvent resultEvent = CoreEvent.builder((CoreEvent)event).message((Message)result).build();
                EventedResult eventedResult = EventedResult.from((CoreEvent)resultEvent);
                return eventedResult;
            }
            Result result2 = Result.builder((Message)event.getMessage()).attributes(null).output(result).build();
            return result2;
        }
        finally {
            bindings.clear();
        }
    }
}

