/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.transformation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.extension.api.transformation.SQLIdentifiersDelimiter;

public class DelimitIdentifiers {
    private static final Map<SQLIdentifiersDelimiter, String> starts = new HashMap<SQLIdentifiersDelimiter, String>(){
        {
            this.put(SQLIdentifiersDelimiter.BACK_TICKS, "`");
            this.put(SQLIdentifiersDelimiter.BRACKETS, "[");
            this.put(SQLIdentifiersDelimiter.DOUBLE_QUOTES, "\"");
        }
    };
    private static final Map<SQLIdentifiersDelimiter, String> ends = new HashMap<SQLIdentifiersDelimiter, String>(){
        {
            this.put(SQLIdentifiersDelimiter.BACK_TICKS, "`");
            this.put(SQLIdentifiersDelimiter.BRACKETS, "]");
            this.put(SQLIdentifiersDelimiter.DOUBLE_QUOTES, "\"");
        }
    };
    private final String start;
    private final String end;

    public DelimitIdentifiers(SQLIdentifiersDelimiter delimiter) {
        this.start = starts.get((Object)delimiter) != null ? starts.get((Object)delimiter) : "";
        this.end = ends.get((Object)delimiter) != null ? ends.get((Object)delimiter) : "";
    }

    public String delimit(String value) {
        return this.start + value + this.end;
    }

    public List<String> delimit(List<String> values) {
        return values.stream().map(this::delimit).collect(Collectors.toList());
    }
}

