/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class FilterExpressionToODataVisitor
implements ExpressionVisitor<VisitorContext> {
    private static final Map<BinaryOperatorKind, Integer> BINARY_OPERATORS_PRIORITY = FilterExpressionToODataVisitor.getBinaryOperatorsPriority();
    private static final Map<UnaryOperatorKind, Integer> UNARY_OPERATORS_PRIORITY = FilterExpressionToODataVisitor.getUnaryOperatorsPriority();
    private static final Map<MethodKind, Integer> METHOD_OPERATORS_PRIORITY = FilterExpressionToODataVisitor.getMethodOperatorsPriority();
    private static final Map<UnaryOperatorKind, String> UNARY_OPERATORS = FilterExpressionToODataVisitor.getUnaryOperators();

    public VisitorContext visitBinaryOperator(BinaryOperatorKind operator, VisitorContext left, VisitorContext right) throws ODataApplicationException {
        Integer operatorPriority = BINARY_OPERATORS_PRIORITY.get(operator);
        if (operatorPriority == null) {
            throw new ODataApplicationException(operator.toString() + " not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        String leftValue = left.getPriority() > operatorPriority ? this.addParenthesis(left.getValue()) : left.getValue();
        String rightValue = right.getPriority() > operatorPriority ? this.addParenthesis(right.getValue()) : right.getValue();
        return new VisitorContext(leftValue + this.surroundWithSpaces(operator.toString()) + rightValue, operatorPriority);
    }

    public VisitorContext visitUnaryOperator(UnaryOperatorKind operator, VisitorContext operand) throws ODataApplicationException {
        Integer operatorPriority = UNARY_OPERATORS_PRIORITY.get(operator);
        if (operatorPriority == null) {
            throw new ODataApplicationException(operator.toString() + " not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        String value = operatorPriority < operand.getPriority() ? this.addParenthesis(operand.getValue()) : operand.getValue();
        return new VisitorContext(UNARY_OPERATORS.get(operator) + value, operatorPriority);
    }

    public VisitorContext visitMethodCall(MethodKind methodCall, List<VisitorContext> parameters) throws ODataApplicationException {
        if (METHOD_OPERATORS_PRIORITY.get(methodCall) == null) {
            throw new ODataApplicationException(methodCall.toString() + " not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return new VisitorContext(methodCall.toString() + this.addParenthesis(parameters.get(0).getValue() + "," + parameters.get(1).getValue()), METHOD_OPERATORS_PRIORITY.get(methodCall));
    }

    public VisitorContext visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitLiteral(Literal literal) {
        return new VisitorContext(literal.getText(), 0);
    }

    public VisitorContext visitMember(Member member) throws ODataApplicationException {
        List resources = member.getResourcePath().getUriResourceParts();
        if (resources.size() == 1 && resources.get(0) instanceof UriResourcePrimitiveProperty) {
            UriResourcePrimitiveProperty first = (UriResourcePrimitiveProperty)resources.get(0);
            return new VisitorContext(first.getProperty().getName(), 0);
        }
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitAlias(String aliasName) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitTypeLiteral(EdmType type) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitLambdaReference(String variableName) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitEnum(EdmEnumType type, List<String> enumValues) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in internal filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public VisitorContext visitBinaryOperator(BinaryOperatorKind operator, VisitorContext left, List<VisitorContext> right) throws ODataApplicationException {
        Integer operatorPriority = BINARY_OPERATORS_PRIORITY.get(operator);
        if (operatorPriority == null) {
            throw new ODataApplicationException(operator.toString() + " not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return new VisitorContext(left.getValue() + this.surroundWithSpaces(operator.toString()) + "(" + right.stream().map(VisitorContext::getValue).collect(Collectors.joining(",")) + ")", operatorPriority);
    }

    private static Map<BinaryOperatorKind, Integer> getBinaryOperatorsPriority() {
        EnumMap<BinaryOperatorKind, Integer> binaryOperators = new EnumMap<BinaryOperatorKind, Integer>(BinaryOperatorKind.class);
        binaryOperators.put(BinaryOperatorKind.OR, 9);
        binaryOperators.put(BinaryOperatorKind.AND, 8);
        binaryOperators.put(BinaryOperatorKind.EQ, 7);
        binaryOperators.put(BinaryOperatorKind.NE, 7);
        binaryOperators.put(BinaryOperatorKind.GE, 6);
        binaryOperators.put(BinaryOperatorKind.GT, 6);
        binaryOperators.put(BinaryOperatorKind.LE, 6);
        binaryOperators.put(BinaryOperatorKind.LT, 6);
        binaryOperators.put(BinaryOperatorKind.ADD, 5);
        binaryOperators.put(BinaryOperatorKind.SUB, 5);
        binaryOperators.put(BinaryOperatorKind.DIV, 4);
        binaryOperators.put(BinaryOperatorKind.MOD, 4);
        binaryOperators.put(BinaryOperatorKind.MUL, 4);
        binaryOperators.put(BinaryOperatorKind.IN, 2);
        return binaryOperators;
    }

    private static Map<UnaryOperatorKind, Integer> getUnaryOperatorsPriority() {
        EnumMap<UnaryOperatorKind, Integer> unaryOperators = new EnumMap<UnaryOperatorKind, Integer>(UnaryOperatorKind.class);
        unaryOperators.put(UnaryOperatorKind.NOT, 3);
        unaryOperators.put(UnaryOperatorKind.MINUS, 3);
        return unaryOperators;
    }

    private static Map<MethodKind, Integer> getMethodOperatorsPriority() {
        EnumMap<MethodKind, Integer> methodOperators = new EnumMap<MethodKind, Integer>(MethodKind.class);
        methodOperators.put(MethodKind.CONTAINS, 2);
        methodOperators.put(MethodKind.STARTSWITH, 2);
        methodOperators.put(MethodKind.ENDSWITH, 2);
        return methodOperators;
    }

    private String addParenthesis(String value) {
        return "(" + value + ")";
    }

    private String surroundWithSpaces(String value) {
        return " " + value + " ";
    }

    private static Map<UnaryOperatorKind, String> getUnaryOperators() {
        EnumMap<UnaryOperatorKind, String> unaryOperators = new EnumMap<UnaryOperatorKind, String>(UnaryOperatorKind.class);
        unaryOperators.put(UnaryOperatorKind.NOT, "not ");
        unaryOperators.put(UnaryOperatorKind.MINUS, "-");
        return unaryOperators;
    }

    public class VisitorContext {
        private String value;
        private int priority;

        private VisitorContext(String value, int priority) {
            this.value = value;
            this.priority = priority;
        }

        public String getValue() {
            return this.value;
        }

        private int getPriority() {
            return this.priority;
        }
    }
}

