/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.routing;

import java.io.InputStream;
import org.mule.extension.api.routing.HttpRequestParameters;
import org.mule.extension.api.routing.RouteOutputAttributes;
import org.mule.extension.internal.ODataConfig;
import org.mule.extension.internal.exception.ODataExceptionHandler;
import org.mule.extension.internal.exception.error.RouterErrorTypeProvider;
import org.mule.extension.internal.model.APIKitODataRequest;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.model.builders.ODataRequestBuilder;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class RouteOperation {
    @MediaType(value="*/*", strict=false)
    @Throws(value={RouterErrorTypeProvider.class})
    @OnException(value=ODataExceptionHandler.class)
    public void route(@Config ODataConfig config, @Content InputStream content, @ParameterGroup(name="HTTP Request Parameters", showInDsl=true) HttpRequestParameters parameters, @Optional(defaultValue="true") @Expression(value=ExpressionSupport.NOT_SUPPORTED) boolean routeCorrelationId, CorrelationInfo correlationInfo, CompletionCallback<InputStream, RouteOutputAttributes> callback, FlowListener flowListener) {
        try {
            APIKitODataRequest request = ((ODataRequestBuilder)((ODataRequestBuilder)((ODataRequestBuilder)((ODataRequestBuilder)((ODataRequestBuilder)ODataRequestBuilder.builder().withContent(content).withHeaders(parameters.getHttpHeaders()).withMethod(parameters.getMethod().toString()).withRawODataPath(parameters.getMaskedRequestPath())).withRawQueryPath(parameters.getRawRequestUri() != null ? this.extractQueryString(parameters.getRawRequestUri()) : parameters.getQueryString())).withScheme(parameters.getScheme())).withHost(parameters.getHost())).withListenerPath(parameters.getListenerPath())).withCorrelationId(routeCorrelationId ? correlationInfo.getCorrelationId() : null).build();
            APIKitODataResponse oDataResponse = config.getHandler().process(request);
            DefaultRoutingContext routingContext = oDataResponse.getRoutingContext();
            if (routingContext != null) {
                routingContext.onSuccess(arg_0 -> callback.success(arg_0));
                routingContext.onError(arg_0 -> callback.error(arg_0));
                flowListener.onComplete(routingContext::dispose);
            } else {
                callback.success(OlingoUtils.toResult(oDataResponse));
            }
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    private String extractQueryString(String uri) {
        int firstQuestionMarkIndex = uri.indexOf(63);
        if (firstQuestionMarkIndex == -1 || firstQuestionMarkIndex == uri.length() - 1) {
            return null;
        }
        return uri.substring(firstQuestionMarkIndex + 1);
    }
}

