/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.extension.api.routing.RouteOutputAttributes;
import org.mule.runtime.api.util.MultiMap;

public class RouteOutputAttributesBuilder {
    private int statusCode;
    private MultiMap<String, String> headers;
    private MultiMap<String, Object> flowAttributes;

    private RouteOutputAttributesBuilder() {
    }

    public static RouteOutputAttributesBuilder builder() {
        return new RouteOutputAttributesBuilder();
    }

    public RouteOutputAttributesBuilder withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public RouteOutputAttributesBuilder withMultipleEntryHeadersMap(Map<String, List<String>> allHeaders) {
        this.headers = new MultiMap();
        allHeaders.forEach((key, value) -> this.headers.put(key, (Collection)value));
        return this;
    }

    public RouteOutputAttributesBuilder withFlowAttributes(MultiMap<String, Object> flowAttributes) {
        this.flowAttributes = flowAttributes;
        return this;
    }

    public RouteOutputAttributes build() {
        RouteOutputAttributes outputAttributes = new RouteOutputAttributes(this.statusCode, this.headers, this.flowAttributes);
        return outputAttributes;
    }
}

