/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.handlers.EntityCollectionResponseHandler;
import org.mule.extension.internal.handlers.EntityResponseHandler;
import org.mule.extension.internal.handlers.RequestHandler;
import org.mule.extension.internal.handlers.ResponseHandler;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.processors.ExpansionProcessor;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.extension.internal.routing.SourceKind;
import org.mule.extension.internal.sources.ExpansionParameters;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RoutingProcessor
implements EntityProcessor,
PrimitiveProcessor,
ComplexProcessor,
EntityCollectionProcessor {
    private final RoutingManager routingManager;
    private RequestHandler requestHandler;
    private EntityResponseHandler entityResponseHandler;
    private EntityCollectionResponseHandler entityCollectionResponseHandler;
    private ExpansionProcessor expansionProcessor;

    public RoutingProcessor(RoutingManager manager) {
        this.routingManager = manager;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.requestHandler = new RequestHandler(this.routingManager);
        this.entityResponseHandler = new EntityResponseHandler(odata, serviceMetadata);
        this.entityCollectionResponseHandler = new EntityCollectionResponseHandler(odata, serviceMetadata);
        this.expansionProcessor = new ExpansionProcessor(odata, serviceMetadata, this.requestHandler, this.routingManager);
    }

    private void completeEntityResponse(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat, Consumer<Result<InputStream, MultiMap<String, Object>>> consumer) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.requestHandler.handleRequest(request, uriInfo, SourceKind.ENTITY);
        CompletableFuture completableResult = routingContext.getFlowCompletableResponse();
        CompletionStage serialized = completableResult.thenApply(result -> {
            if (HttpMethod.DELETE.equals((Object)request.getMethod())) {
                return Result.builder().output(result.getResponseContent().getValue()).mediaType(result.getResponseContent().getDataType().getMediaType()).attributes(result.getFlowResponseMetadataProperties()).build();
            }
            return this.entityResponseHandler.serializeResponse(result, request, uriInfo, responseFormat);
        });
        routingContext.setOdataCompletableResponse((CompletableFuture<ODataResponse>)((CompletableFuture)serialized).thenApply(result -> {
            consumer.accept((Result<InputStream, MultiMap<String, Object>>)result);
            return response;
        }));
        OlingoUtils.getAPIKitResponse(response).setRoutingContext(routingContext);
    }

    public <T, R extends SuccessResponse> void completeExpansibleResponse(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat, SourceKind kind, ResponseHandler<T, R> responseHandler) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.requestHandler.handleRequest(request, uriInfo, kind);
        APIKitODataResponse apiKitResponse = OlingoUtils.getAPIKitResponse(response);
        CompletableFuture completableResult = routingContext.getFlowCompletableResponse();
        RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration> routingKey = OlingoUtils.getRoutingKey(request, uriInfo, kind);
        ExpansionParameters expansionParameters = this.routingManager.getExpansionParametersConfig(routingKey).getExpansionParameters();
        CompletionStage serialized = ((CompletableFuture)completableResult.thenCompose(result -> result.isRaw() ? CompletableFuture.completedFuture(result) : this.expansionProcessor.resolveExpansion(expansionParameters, (SuccessResponse)result, request, uriInfo))).thenApply(expandedResult -> responseHandler.serializeResponse(expandedResult, request, uriInfo, responseFormat));
        routingContext.setOdataCompletableResponse((CompletableFuture<ODataResponse>)((CompletableFuture)serialized).thenApply(result -> {
            response.setContent((InputStream)result.getOutput());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", responseFormat.toContentTypeString());
            apiKitResponse.setFlowAttributes((MultiMap<String, Object>)result.getAttributes().orElse(MultiMap.emptyMultiMap()));
            return response;
        }));
        apiKitResponse.setRoutingContext(routingContext);
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeExpansibleResponse(request, response, uriInfo, responseFormat, SourceKind.ENTITY, this.entityResponseHandler);
    }

    public void readEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY_COLLECTION);
        this.completeExpansibleResponse(request, response, uriInfo, responseFormat, SourceKind.ENTITY_COLLECTION, this.entityCollectionResponseHandler);
    }

    public void readPrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void readComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void createEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.CREATED));
    }

    public void updateComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deleteComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    public void updateEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deleteEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    public void updatePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deletePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        this.expandEnabled(request, uriInfo, SourceKind.ENTITY);
        this.completeEntityResponse(request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    private Consumer<Result<InputStream, MultiMap<String, Object>>> getSourceOutputResponseConsumer(ODataResponse response, ContentType responseFormat, HttpStatusCode statusCode) {
        return result -> {
            if (result != null) {
                response.setContent((InputStream)result.getOutput());
            }
            if (statusCode != null) {
                response.setStatusCode(statusCode.getStatusCode());
            }
            if (responseFormat != null) {
                response.setHeader("Content-Type", responseFormat.toContentTypeString());
            }
            if (response instanceof APIKitODataResponse) {
                ((APIKitODataResponse)response).setFlowAttributes((MultiMap<String, Object>)result.getAttributes().orElse(new MultiMap()));
            }
        };
    }

    private void expandEnabled(ODataRequest request, UriInfo uriInfo, SourceKind sourceKind) throws CompletionException {
        RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration> routingKey = OlingoUtils.getRoutingKey(request, uriInfo, sourceKind);
        if (this.isExpandRequested(uriInfo) && !this.isExpandRequestSupported(routingKey)) {
            ODataApplicationException ex = new ODataApplicationException(String.format("$expand option support is disabled for: %s", OlingoUtils.getUriLastResourcePart(uriInfo)), HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
            throw new CompletionException(ex);
        }
    }

    private boolean isExpandRequested(UriInfo uriInfo) {
        return uriInfo.getExpandOption() != null && uriInfo.getExpandOption().getExpandItems() != null && !uriInfo.getExpandOption().getExpandItems().isEmpty();
    }

    private boolean isExpandRequestSupported(RoutingKey<?, ?, SourceConfiguration> routingKey) {
        SourceConfiguration expansionParametersConfig = this.routingManager.getExpansionParametersConfig(routingKey);
        if (expansionParametersConfig == null) {
            return false;
        }
        return expansionParametersConfig.getSystemQueryOptionsParameters().isExpandSupported();
    }
}

