/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import org.mule.extension.api.constants.HttpScheme;

public abstract class BaseRequestBuilder<R, B extends BaseRequestBuilder<R, B>> {
    protected String rawODataPath;
    protected String rawQueryPath;
    protected HttpScheme scheme;
    protected String host;
    protected String listenerPath;

    protected abstract B getThis();

    public abstract R build();

    protected String buildRawRequestUri(String rawBaseUri, String rawODataPath, String rawQueryPath) {
        return String.format("%s%s%s", rawBaseUri, rawODataPath.startsWith("/") ? rawODataPath.substring(1) : rawODataPath, rawQueryPath != null ? "?" + rawQueryPath : "");
    }

    protected String buildRawBaseUri(HttpScheme scheme, String host, String listenerPath) {
        return String.format("%s://%s%s", scheme.name().toLowerCase(), host, listenerPath.substring(0, listenerPath.length() - 1));
    }

    public B withRawODataPath(String rawODataPath) {
        this.rawODataPath = rawODataPath;
        return this.getThis();
    }

    public B withRawQueryPath(String rawQueryPath) {
        this.rawQueryPath = rawQueryPath;
        return this.getThis();
    }

    public B withScheme(HttpScheme scheme) {
        this.scheme = scheme;
        return this.getThis();
    }

    public B withHost(String host) {
        this.host = host;
        return this.getThis();
    }

    public B withListenerPath(String listenerPath) {
        this.listenerPath = listenerPath;
        return this.getThis();
    }
}

