/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.handlers;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.exception.DeserializationException;
import org.mule.extension.internal.exception.error.ODataError;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public abstract class ResponseHandler<T, R extends SuccessResponse> {
    protected final OData oData;
    protected final ServiceMetadata serviceMetadata;

    public ResponseHandler(OData oData, ServiceMetadata serviceMetadata) {
        this.oData = oData;
        this.serviceMetadata = serviceMetadata;
    }

    public Result<InputStream, MultiMap<String, Object>> serializeResponse(R flowResponse, ODataRequest request, UriInfo uriInfo, ContentType responseFormat) {
        if (flowResponse.isRaw()) {
            return this.serializeRawResponse(flowResponse);
        }
        EdmEntityType entityType = OlingoUtils.getReturnEntityType(uriInfo).orElse(null);
        if (entityType == null) {
            throw new DeserializationException("Unable to infer the target entity type from the request");
        }
        T entity = this.deserialize((InputStream)flowResponse.getResponseContent().getValue(), ContentType.APPLICATION_JSON, entityType);
        return this.serialize(entity, flowResponse, uriInfo, request, responseFormat);
    }

    private Result<InputStream, MultiMap<String, Object>> serializeRawResponse(R flowResponse) {
        if (!flowResponse.isRaw()) {
            throw new IllegalArgumentException("Expected a raw SuccessResponse");
        }
        return Result.builder().output(flowResponse.getResponseContent().getValue()).mediaType(flowResponse.getResponseContent().getDataType().getMediaType()).attributes(flowResponse.getFlowResponseMetadataProperties()).build();
    }

    protected abstract T deserialize(InputStream var1, ContentType var2, EdmEntityType var3);

    protected abstract Result<InputStream, MultiMap<String, Object>> serialize(T var1, R var2, UriInfo var3, ODataRequest var4, ContentType var5);

    protected abstract void addSuffix(UriResource var1, ContextURL.Builder var2);

    protected abstract Serialize getSerializationFunctionByUriResourceType(T var1, ODataSerializer var2, EdmEntityType var3, UriInfo var4, String var5);

    protected ContextURL getContextUrl(String rawBaseUri, UriInfo uriInfo) {
        try {
            List parts = uriInfo.getUriResourceParts();
            UriResourceEntitySet uriResource = (UriResourceEntitySet)parts.get(0);
            EdmEntitySet entitySet = uriResource.getEntitySet();
            ContextURL.Builder builder = ContextURL.with().serviceRoot(new URI(rawBaseUri)).entitySet(entitySet);
            this.addSuffix((UriResource)parts.get(parts.size() - 1), builder);
            if (uriInfo.getSelectOption() != null) {
                builder.selectList(uriInfo.getSelectOption().getText());
            }
            if (parts.size() == 1) {
                return builder.build();
            }
            builder.keyPath(ContextURLHelper.buildKeyPredicate((List)uriResource.getKeyPredicates()));
            StringBuilder stringBuilder = new StringBuilder();
            return builder.navOrPropertyPath(this.buildNavigation(stringBuilder, 1, parts)).build();
        }
        catch (URISyntaxException | SerializerException e) {
            throw new ModuleException("An error occurred while building context URL", (ErrorTypeDefinition)ODataError.SERIALIZATION, e);
        }
    }

    private String buildNavigation(StringBuilder stringBuilder, Integer index, List<UriResource> parts) throws SerializerException {
        if (index == parts.size() - 1) {
            return stringBuilder.append(parts.get(index).getSegmentValue()).toString();
        }
        UriResourceNavigation navigation = (UriResourceNavigation)parts.get(index);
        return this.buildNavigation(stringBuilder.append(navigation.getSegmentValue()).append('(').append(ContextURLHelper.buildKeyPredicate((List)navigation.getKeyPredicates())).append(')').append("/"), index + 1, parts);
    }

    protected ContentType getResponseFormat(ContentType responseFormat) {
        return responseFormat != null ? responseFormat : ContentType.APPLICATION_JSON;
    }

    @FunctionalInterface
    public static interface Serialize {
        public SerializerResult serialize();
    }
}

