/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.handlers;

import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.exception.DeserializationException;
import org.mule.extension.internal.exception.SerializationException;
import org.mule.extension.internal.exception.error.ODataError;
import org.mule.extension.internal.handlers.ResponseHandler;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class EntityResponseHandler
extends ResponseHandler<Entity, SuccessResponse> {
    public EntityResponseHandler(OData oData, ServiceMetadata serviceMetadata) {
        super(oData, serviceMetadata);
    }

    @Override
    protected Entity deserialize(InputStream inboundContent, ContentType inboundContentType, EdmEntityType entityType) {
        try {
            return this.oData.createDeserializer(inboundContentType, this.serviceMetadata).entity(inboundContent, entityType).getEntity();
        }
        catch (DeserializerException e) {
            throw new DeserializationException(String.format("An error occurred while deserializing entity %s", entityType.getName()), e);
        }
    }

    @Override
    protected Result<InputStream, MultiMap<String, Object>> serialize(Entity entity, SuccessResponse flowResponse, UriInfo uriInfo, ODataRequest request, ContentType responseFormat) {
        try {
            if (entity.getProperties().isEmpty()) {
                throw new CompletionException(new ODataApplicationException("Entity Not Found", HttpStatusCode.NOT_FOUND.getStatusCode(), Locale.ENGLISH));
            }
            ContentType outputFormat = this.getResponseFormat(responseFormat);
            ResponseHandler.Serialize serialize = this.getSerializationFunctionByUriResourceType(entity, this.oData.createSerializer(outputFormat), (EdmEntityType)OlingoUtils.getReturnEntityType(uriInfo).orElse(null), uriInfo, request.getRawBaseUri());
            return Result.builder().output((Object)serialize.serialize().getContent()).mediaType(MediaType.parse((String)outputFormat.toContentTypeString())).attributes(flowResponse.getFlowResponseMetadataProperties()).build();
        }
        catch (CompletionException | ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException("Exception while serializing Entity", e);
        }
    }

    @Override
    protected void addSuffix(UriResource uriResource, ContextURL.Builder builder) {
        UriResourceKind kind = uriResource.getKind();
        if (UriResourceKind.entitySet.equals((Object)kind) || UriResourceKind.navigationProperty.equals((Object)kind)) {
            builder.suffix(ContextURL.Suffix.ENTITY);
        } else if (UriResourceKind.ref.equals((Object)kind)) {
            builder.suffix(ContextURL.Suffix.REFERENCE);
        }
    }

    @Override
    protected ResponseHandler.Serialize getSerializationFunctionByUriResourceType(Entity content, ODataSerializer serializer, EdmEntityType entityType, UriInfo uriInfo, String rawBaseUri) {
        UriResource lastResourcePart = OlingoUtils.getUriLastResourcePart(uriInfo);
        if (lastResourcePart instanceof UriResourcePartTyped) {
            EdmTypeKind typeKind = ((UriResourcePartTyped)lastResourcePart).getType().getKind();
            ContextURL contextUrl = this.getContextUrl(rawBaseUri, uriInfo);
            if (EdmTypeKind.ENTITY.equals((Object)typeKind)) {
                return this.getEntitySerialize(serializer, uriInfo, content, entityType, contextUrl);
            }
            if (EdmTypeKind.PRIMITIVE.equals((Object)typeKind) || EdmTypeKind.COMPLEX.equals((Object)typeKind)) {
                return this.getPropertySerialize(serializer, content, (UriResourceProperty)lastResourcePart, typeKind, contextUrl);
            }
            throw new ModuleException(String.format("Unable to find serializer for EDM Type %s", typeKind), (ErrorTypeDefinition)ODataError.INTERNAL_SERVER_ERROR);
        }
        throw new ModuleException(String.format("Unable to find serializer for %s", lastResourcePart.getKind()), (ErrorTypeDefinition)ODataError.INTERNAL_SERVER_ERROR);
    }

    private ResponseHandler.Serialize getPropertySerialize(ODataSerializer serializer, Entity entity, UriResourceProperty lastResourcePart, EdmTypeKind typeKind, ContextURL contextUrl) {
        UriResourceProperty uriProperty = lastResourcePart;
        EdmProperty edmProperty = uriProperty.getProperty();
        Property property = entity.getProperty(edmProperty.getName());
        if (property == null) {
            throw new SerializationException(String.format("Property %s not found", edmProperty.getName()));
        }
        if (EdmTypeKind.PRIMITIVE.equals((Object)typeKind)) {
            return this.getPrimitiveSerialize(serializer, property, edmProperty, contextUrl);
        }
        if (EdmTypeKind.COMPLEX.equals((Object)typeKind)) {
            return this.getComplexSerialize(serializer, property, edmProperty, contextUrl);
        }
        return null;
    }

    private ResponseHandler.Serialize getComplexSerialize(ODataSerializer serializer, Property property, EdmProperty edmProperty, ContextURL contextURL) {
        return () -> {
            try {
                return serializer.complex(this.serviceMetadata, (EdmComplexType)edmProperty.getType(), property, ComplexSerializerOptions.with().contextURL(contextURL).build());
            }
            catch (SerializerException e) {
                throw new SerializationException(String.format("An error occurred while serializing complex property %s", edmProperty.getName()), e);
            }
        };
    }

    private ResponseHandler.Serialize getPrimitiveSerialize(ODataSerializer serializer, Property property, EdmProperty edmProperty, ContextURL contextURL) {
        return () -> {
            try {
                return serializer.primitive(this.serviceMetadata, (EdmPrimitiveType)edmProperty.getType(), property, PrimitiveSerializerOptions.with().contextURL(contextURL).scale(edmProperty.getScale()).nullable(Boolean.valueOf(edmProperty.isNullable())).precision(edmProperty.getPrecision()).maxLength(edmProperty.getMaxLength()).unicode(Boolean.valueOf(edmProperty.isUnicode())).build());
            }
            catch (SerializerException e) {
                throw new SerializationException(String.format("An error occurred while serializing primitive property %s", edmProperty.getName()), e);
            }
        };
    }

    private ResponseHandler.Serialize getEntitySerialize(ODataSerializer serializer, UriInfo uriInfo, Entity entity, EdmEntityType entityType, ContextURL contextURL) {
        return () -> {
            try {
                return serializer.entity(this.serviceMetadata, entityType, entity, EntitySerializerOptions.with().contextURL(contextURL).expand(uriInfo.getExpandOption()).select(uriInfo.getSelectOption()).build());
            }
            catch (SerializerException e) {
                throw new SerializationException(String.format("An error occurred while serializing entity %s", entity.getType()), e);
            }
        };
    }
}

