/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.sources;

import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ExpansionParameters {
    @Parameter
    @NullSafe
    @Optional
    @Placement(order=1, tab="Capabilities")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Generic expansion navigation properties")
    @Summary(value="List of navigation properties for which generic expansion is enabled")
    private List<String> expandableProperties;
    @Parameter
    @Optional(defaultValue="false")
    @Placement(order=2, tab="Capabilities")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Whether an error should be ignored during execution of subsequent flows of the expansion")
    private boolean ignoreErrorsOnExpansionEnabled;

    public boolean isEmpty() {
        return this.expandableProperties.isEmpty();
    }

    public List<String> getExpandableProperties() {
        return this.expandableProperties;
    }

    public boolean isIgnoreErrorsOnExpansionEnabled() {
        return this.ignoreErrorsOnExpansionEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpansionParameters that = (ExpansionParameters)o;
        return this.ignoreErrorsOnExpansionEnabled == that.ignoreErrorsOnExpansionEnabled && this.expandableProperties.equals(that.expandableProperties);
    }

    public int hashCode() {
        return Objects.hash(this.expandableProperties, this.ignoreErrorsOnExpansionEnabled);
    }
}

