/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.routing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.extension.internal.exception.NotImplementedException;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RoutingManager<T, I, C> {
    protected final Map<RoutingKey, C> routeConfigurations = new ConcurrentHashMap<RoutingKey, C>();
    protected final Map<RoutingKey, Function<Result<T, I>, DefaultRoutingContext>> callbacks = new ConcurrentHashMap<RoutingKey, Function<Result<T, I>, DefaultRoutingContext>>();

    public void registerListener(RoutingKey routingKey, Function<Result<T, I>, DefaultRoutingContext> callback, C config) {
        if (this.callbacks.put(routingKey, callback) != null) {
            throw new IllegalStateException("Duplicated Entries");
        }
        if (config != null && this.routeConfigurations.put(routingKey, config) != null) {
            throw new IllegalStateException("Duplicated Entries");
        }
    }

    public void unregisterListenerContext(RoutingKey routingKey) {
        this.callbacks.remove(routingKey);
        this.routeConfigurations.remove(routingKey);
    }

    public C getExpansionParametersConfig(RoutingKey routingKey) {
        this.validateCallbackIsRegistered(routingKey);
        return this.routeConfigurations.get(routingKey);
    }

    public RoutingContext route(RoutingKey routingKey, Result<T, I> sourceInput) {
        this.validateCallbackIsRegistered(routingKey);
        return this.callbacks.get(routingKey).apply(sourceInput);
    }

    private void validateCallbackIsRegistered(RoutingKey routingKey) {
        if (this.callbacks.get(routingKey) == null) {
            throw new NotImplementedException(String.format("Missing flow implementation for key: {%s}", routingKey.toString()));
        }
    }
}

