/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataRequest;
import org.mule.extension.internal.model.APIKitODataRequest;
import org.mule.extension.internal.model.builders.BaseRequestBuilder;

public class ODataRequestBuilder
extends BaseRequestBuilder<APIKitODataRequest, ODataRequestBuilder> {
    private InputStream content;
    private Map<String, String> headers;
    private String method;

    private ODataRequestBuilder() {
    }

    public static ODataRequestBuilder builder() {
        return new ODataRequestBuilder();
    }

    public ODataRequestBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public ODataRequestBuilder withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public ODataRequestBuilder withMethod(String method) {
        this.method = method;
        return this;
    }

    @Override
    protected ODataRequestBuilder getThis() {
        return this;
    }

    @Override
    public APIKitODataRequest build() {
        APIKitODataRequest request = new APIKitODataRequest();
        String rawBaseUri = this.buildRawBaseUri(this.scheme, this.host, this.listenerPath);
        request.setBody(this.content);
        this.copyHeaders(request, this.headers == null ? Collections.emptyMap() : this.headers);
        request.setMethod(HttpMethod.valueOf((String)this.method));
        request.setRawODataPath(this.rawODataPath);
        request.setRawQueryPath(this.rawQueryPath);
        request.setRawBaseUri(rawBaseUri);
        request.setRawRequestUri(this.buildRawRequestUri(rawBaseUri, this.rawODataPath, this.rawQueryPath));
        request.setProtocol(this.scheme.name());
        return request;
    }

    private void copyHeaders(ODataRequest request, Map<String, String> headers) {
        headers.entrySet().forEach(entry -> request.setHeader((String)entry.getKey(), (String)entry.getValue()));
    }
}

