/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.handlers;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.uri.UriInfo;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.routing.ODataRequestAttributes;
import org.mule.extension.internal.model.builders.ODataHttpAttributesBuilder;
import org.mule.extension.internal.model.builders.ODataRequestAttributesBuilder;
import org.mule.extension.internal.routing.RoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.extension.internal.routing.SourceKind;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RequestHandler {
    private final RoutingManager<InputStream, ListenerRequestAttributes, SourceConfiguration> routingManager;

    public RequestHandler(RoutingManager<InputStream, ListenerRequestAttributes, SourceConfiguration> routingManager) {
        this.routingManager = routingManager;
    }

    public RoutingContext handleRequest(ODataRequest request, UriInfo uriInfo, SourceKind kind) {
        EdmEntityType entityType = OlingoUtils.getReturnEntityType(uriInfo).orElse(null);
        return this.routeRequest(request, uriInfo, kind, entityType);
    }

    private RoutingContext routeRequest(ODataRequest request, UriInfo uriInfo, SourceKind kind, EdmEntityType entityType) {
        RoutingKey routingKey = OlingoUtils.getRoutingKey(request, uriInfo, kind);
        return this.routingManager.route(routingKey, (Result<InputStream, ListenerRequestAttributes>)Result.builder().output((Object)request.getBody()).mediaType(this.getPayloadMediaType(request)).attributes((Object)this.getInputAttributes(uriInfo, entityType, request)).build());
    }

    private MediaType getPayloadMediaType(ODataRequest request) {
        String contentType = request.getHeader("Content-Type");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contentType}) ? MediaType.parse((String)contentType) : MediaType.ANY;
    }

    private ListenerRequestAttributes getInputAttributes(UriInfo uriInfo, EdmEntityType entityType, ODataRequest request) {
        Map<String, String> entityTypeKeys = OlingoUtils.getEntityTypeKeysFromUriParameters(uriInfo.getUriResourceParts());
        Map<String, String> systemQueryOptions = OlingoUtils.getSystemQueryOptions(uriInfo.getSystemQueryOptions());
        MultiMap<String, String> customQueryOptions = OlingoUtils.getCustomQueryOptions(uriInfo.getCustomQueryOptions());
        List<String> entityTypeFields = OlingoUtils.getEntityTypeFields(entityType);
        ODataRequestAttributes requestAttributes = ODataRequestAttributesBuilder.builder().withEntityTypeName(OlingoUtils.getEntityTypeName(entityType).orElse("")).withEntityTypeFields(entityTypeFields).withEntityTypeKeys(entityTypeKeys).withSystemQueryOptions(systemQueryOptions).withCustomQueryOptions(customQueryOptions).build();
        return new ListenerRequestAttributes(requestAttributes, ODataHttpAttributesBuilder.from(request), OlingoUtils.getEntitySetName(uriInfo).orElse(""));
    }
}

