/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.mule.extension.internal.model.CsdlEdmProvider;
import org.mule.extension.internal.processors.OData4Handler;
import org.mule.extension.internal.processors.RoutingProcessor;
import org.mule.extension.internal.processors.ServiceDocumentProcessor;
import org.mule.extension.internal.routing.RouteOperation;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.extension.internal.serialization.SerializeEntityCollectionResponseOperation;
import org.mule.extension.internal.serialization.SerializeEntityResponseOperation;
import org.mule.extension.internal.sources.EntityCollectionSource;
import org.mule.extension.internal.sources.EntitySource;
import org.mule.extension.internal.transformation.TransformToSQLOperation;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Operations(value={RouteOperation.class, TransformToSQLOperation.class, SerializeEntityResponseOperation.class, SerializeEntityCollectionResponseOperation.class})
@Sources(value={EntitySource.class, EntityCollectionSource.class})
public class ODataConfig
implements Initialisable,
Stoppable {
    @Parameter
    @Summary(value="API definition")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String apiDefinition;
    @Inject
    private RoutingManager routingManager;
    private OData4Handler handler;

    public void initialise() {
        OData odata = OData.newInstance();
        ServiceMetadata serviceMetadata = odata.createServiceMetadata((org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider)new CsdlEdmProvider(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.apiDefinition)){}, new ArrayList());
        this.handler = new OData4Handler(odata, serviceMetadata);
        RoutingProcessor routingProcessor = new RoutingProcessor(this.routingManager);
        routingProcessor.init(odata, serviceMetadata);
        this.handler.register((Processor)routingProcessor);
        ServiceDocumentProcessor serviceDocumentProcessor = new ServiceDocumentProcessor();
        serviceDocumentProcessor.init(odata, serviceMetadata);
        this.handler.register((Processor)serviceDocumentProcessor);
        this.handler.register((Processor)new DefaultProcessor());
    }

    public void stop() {
        this.handler = null;
    }

    public String getApiDefinition() {
        return this.apiDefinition;
    }

    public OData4Handler getHandler() {
        return this.handler;
    }
}

