/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.transformation;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;
import org.mule.extension.internal.transformation.DelimitIdentifiers;
import org.mule.extension.internal.transformation.SQLPreparedStatementBuilder;

public class FilterExpressionVisitor
implements ExpressionVisitor<String> {
    private static final Map<BinaryOperatorKind, String> BINARY_OPERATORS = FilterExpressionVisitor.getBinaryOperators();
    private static final Map<UnaryOperatorKind, String> UNARY_OPERATORS = FilterExpressionVisitor.getUnaryOperators();
    private static final Map<MethodKind, String> METHOD_OPERATORS = FilterExpressionVisitor.getMethodOperators();
    private static final Map<MethodKind, Function<Object, String>> METHOD_PARAMETER = FilterExpressionVisitor.getMethodParameter();
    private final SQLPreparedStatementBuilder sqlPreparedStatementBuilder;
    private final DelimitIdentifiers delimitIdentifiers;

    public FilterExpressionVisitor(SQLPreparedStatementBuilder sqlPreparedStatementBuilder, DelimitIdentifiers delimitIdentifiers) {
        this.sqlPreparedStatementBuilder = sqlPreparedStatementBuilder;
        this.delimitIdentifiers = delimitIdentifiers;
    }

    public String visitBinaryOperator(BinaryOperatorKind operator, String left, String right) throws ODataApplicationException {
        if (BINARY_OPERATORS.get(operator) == null) {
            throw new ODataApplicationException(operator.toString() + "not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return "(" + left + BINARY_OPERATORS.get(operator) + right + ")";
    }

    public String visitUnaryOperator(UnaryOperatorKind operator, String operand) throws ODataApplicationException {
        if (UNARY_OPERATORS.get(operator) == null) {
            throw new ODataApplicationException(operator.toString() + "not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return UNARY_OPERATORS.get(operator) + operand;
    }

    public String visitMethodCall(MethodKind methodCall, List<String> parameters) throws ODataApplicationException {
        if (METHOD_OPERATORS.get(methodCall) == null) {
            throw new ODataApplicationException(methodCall.toString() + "not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        String parameterName = parameters.get(1);
        String method = METHOD_OPERATORS.get(methodCall);
        Object value = this.sqlPreparedStatementBuilder.getParameterValue(parameterName);
        String transformedValue = METHOD_PARAMETER.get(methodCall).apply(value);
        this.sqlPreparedStatementBuilder.replaceParameterValue(parameterName, transformedValue);
        return parameters.get(0) + method + parameters.get(1);
    }

    public String visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public String visitLiteral(Literal literal) {
        String value = literal.getText();
        if (value != null && value.length() > 1 && value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value != null && value.contains("''")) {
            value = value.replace("''", "'");
        }
        return this.sqlPreparedStatementBuilder.getParameterKey(literal.getType() == null ? "NULL" : value);
    }

    public String visitMember(Member member) throws ODataApplicationException {
        List resources = member.getResourcePath().getUriResourceParts();
        if (resources.size() == 1 && resources.get(0) instanceof UriResourcePrimitiveProperty) {
            UriResourcePrimitiveProperty first = (UriResourcePrimitiveProperty)resources.get(0);
            return this.delimitIdentifiers.delimit(first.getProperty().getName());
        }
        throw new ODataApplicationException("Only primitive properties are implemented in filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public String visitAlias(String aliasName) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public String visitTypeLiteral(EdmType type) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public String visitLambdaReference(String variableName) throws ODataApplicationException {
        throw new ODataApplicationException("Only primitive properties are implemented in filter expressions", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
    }

    public String visitEnum(EdmEnumType type, List<String> enumValues) {
        return this.sqlPreparedStatementBuilder.getParameterKey(enumValues.get(0));
    }

    public String visitBinaryOperator(BinaryOperatorKind operator, String left, List<String> right) throws ODataApplicationException {
        if (BINARY_OPERATORS.get(operator) == null) {
            throw new ODataApplicationException(operator.toString() + "not implemented", HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.ENGLISH);
        }
        return left + BINARY_OPERATORS.get(operator) + "(" + right.stream().collect(Collectors.joining(",")) + ")";
    }

    private static Map<BinaryOperatorKind, String> getBinaryOperators() {
        HashMap<BinaryOperatorKind, String> binaryOperators = new HashMap<BinaryOperatorKind, String>();
        binaryOperators.put(BinaryOperatorKind.ADD, " + ");
        binaryOperators.put(BinaryOperatorKind.AND, " AND ");
        binaryOperators.put(BinaryOperatorKind.DIV, " / ");
        binaryOperators.put(BinaryOperatorKind.EQ, " = ");
        binaryOperators.put(BinaryOperatorKind.GE, " >= ");
        binaryOperators.put(BinaryOperatorKind.GT, " > ");
        binaryOperators.put(BinaryOperatorKind.LE, " <= ");
        binaryOperators.put(BinaryOperatorKind.LT, " < ");
        binaryOperators.put(BinaryOperatorKind.MOD, " % ");
        binaryOperators.put(BinaryOperatorKind.MUL, " * ");
        binaryOperators.put(BinaryOperatorKind.NE, " <> ");
        binaryOperators.put(BinaryOperatorKind.OR, " OR ");
        binaryOperators.put(BinaryOperatorKind.SUB, " - ");
        binaryOperators.put(BinaryOperatorKind.IN, " IN ");
        return binaryOperators;
    }

    private static Map<UnaryOperatorKind, String> getUnaryOperators() {
        HashMap<UnaryOperatorKind, String> unaryOperators = new HashMap<UnaryOperatorKind, String>();
        unaryOperators.put(UnaryOperatorKind.NOT, "NOT ");
        unaryOperators.put(UnaryOperatorKind.MINUS, "-");
        return unaryOperators;
    }

    private static Map<MethodKind, String> getMethodOperators() {
        HashMap<MethodKind, String> methodOperators = new HashMap<MethodKind, String>();
        methodOperators.put(MethodKind.CONTAINS, " LIKE ");
        methodOperators.put(MethodKind.STARTSWITH, " LIKE ");
        methodOperators.put(MethodKind.ENDSWITH, " LIKE ");
        return methodOperators;
    }

    private static Map<MethodKind, Function<Object, String>> getMethodParameter() {
        HashMap<MethodKind, Function<Object, String>> methodParameter = new HashMap<MethodKind, Function<Object, String>>();
        methodParameter.put(MethodKind.CONTAINS, value -> "%" + value + "%");
        methodParameter.put(MethodKind.STARTSWITH, value -> value + "%");
        methodParameter.put(MethodKind.ENDSWITH, value -> "%" + value);
        return methodParameter;
    }
}

