/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.sources;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.serialization.CollectionSuccessResponse;
import org.mule.extension.api.serialization.EntityCollectionSuccessResponse;
import org.mule.extension.internal.datasense.EntityCollectionKeyResolver;
import org.mule.extension.internal.datasense.OutputEntityCollectionResolver;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.EntityCollectionRoutingManager;
import org.mule.extension.internal.sources.BaseSource;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;

@MetadataScope(keysResolver=EntityCollectionKeyResolver.class, outputResolver=OutputEntityCollectionResolver.class)
@MediaType(value="*/*", strict=false)
@Alias(value="RequestEntityCollectionListener")
@DisplayName(value="On Entity Collection Request")
@EmitsResponse
public class EntityCollectionSource
extends BaseSource<InputStream, ListenerRequestAttributes, EntityCollectionRoutingManager> {
    public void onStart(SourceCallback<InputStream, ListenerRequestAttributes> sourceCallback) {
        Function callback = input -> {
            SourceCallbackContext ctx = sourceCallback.createContext();
            CompletableFuture completableResult = new CompletableFuture();
            DefaultRoutingContext routingContext = new DefaultRoutingContext(completableResult);
            ctx.addVariable("routingContext", routingContext);
            sourceCallback.handle(input, ctx);
            return routingContext;
        };
        ((EntityCollectionRoutingManager)this.routingManager).registerListenerCallback(this.routingKey, callback);
    }

    @OnSuccess
    public void onSuccess(@Placement(tab="Responses") @NullSafe(defaultImplementingType=EntityCollectionSuccessResponse.class) @Optional CollectionSuccessResponse collectionSuccessResponse, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) {
        DefaultRoutingContext routingContext = this.getRoutingContext(callbackContext);
        routingContext.setSourceCompletionCallback(completionCallback);
        routingContext.getFlowCompletableResponse().complete(collectionSuccessResponse);
    }
}

