/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.routing;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.extension.internal.exception.NotImplementedException;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.runtime.extension.api.runtime.operation.Result;

public abstract class RoutingManager<I> {
    protected final Map<RoutingKey, Function<Result<InputStream, I>, DefaultRoutingContext>> callbacks = new ConcurrentHashMap<RoutingKey, Function<Result<InputStream, I>, DefaultRoutingContext>>();

    public void registerListenerCallback(RoutingKey routingKey, Function<Result<InputStream, I>, DefaultRoutingContext> callback) {
        if (this.callbacks.put(routingKey, callback) != null) {
            throw new IllegalStateException("Duplicated Entries");
        }
    }

    public void unregisterListenerCallback(RoutingKey routingKey) {
        this.callbacks.remove(routingKey);
    }

    public RoutingContext route(RoutingKey routingKey, Result<InputStream, I> sourceInput) throws NotImplementedException {
        Function<Result<InputStream, I>, DefaultRoutingContext> routingCallback = this.callbacks.get(routingKey);
        if (routingCallback == null) {
            throw new NotImplementedException(String.format("Missing flow implementation for key: {%s}", routingKey.toString()));
        }
        DefaultRoutingContext routingContext = routingCallback.apply(sourceInput);
        return routingContext;
    }
}

