/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.PrimitiveProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.mule.extension.api.serialization.RawEntitySuccessResponse;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.handlers.EntityResponseHandler;
import org.mule.extension.internal.handlers.RequestHandler;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.EntityRoutingManager;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class SingleEntityProcessor
implements EntityProcessor,
PrimitiveProcessor,
ComplexProcessor {
    private final EntityRoutingManager entityRoutingManager;
    private RequestHandler entityRequestHandler;
    private EntityResponseHandler entityResponseHandler;

    public SingleEntityProcessor(EntityRoutingManager manager) {
        this.entityRoutingManager = manager;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.entityRequestHandler = new RequestHandler(this.entityRoutingManager);
        this.entityResponseHandler = new EntityResponseHandler(odata, serviceMetadata);
    }

    private void completeResponse(DefaultRoutingContext<SuccessResponse> routingContext, ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat, Consumer<Result<InputStream, MultiMap<String, Object>>> consumer) {
        CompletableFuture<SuccessResponse> completableResult = routingContext.getFlowCompletableResponse();
        CompletionStage serialized = completableResult.thenApply(result -> {
            if (HttpMethod.DELETE.equals((Object)request.getMethod()) || result instanceof RawEntitySuccessResponse) {
                return Result.builder().output(result.getResponseContent().getValue()).mediaType(result.getResponseContent().getDataType().getMediaType()).attributes(result.getFlowResponseMetadataProperties()).build();
            }
            return this.entityResponseHandler.serializeResponse(result, request, uriInfo, responseFormat);
        });
        routingContext.setOdataCompletableResponse((CompletableFuture<ODataResponse>)((CompletableFuture)serialized).thenApply(result -> {
            consumer.accept((Result<InputStream, MultiMap<String, Object>>)result);
            return response;
        }));
        OlingoUtils.getAPIKitResponse(response).setRoutingContext(routingContext);
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void readPrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void readComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void createEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.CREATED));
    }

    public void updateComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deleteComplex(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    public void updateEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deleteEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    public void updatePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, responseFormat, this.getSourceOutputResponseConsumer(response, responseFormat, HttpStatusCode.OK));
    }

    public void deletePrimitive(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityRequestHandler.handleRequest(request, uriInfo);
        this.completeResponse(routingContext, request, response, uriInfo, null, this.getSourceOutputResponseConsumer(response, null, HttpStatusCode.NO_CONTENT));
    }

    private Consumer<Result<InputStream, MultiMap<String, Object>>> getSourceOutputResponseConsumer(ODataResponse response, ContentType responseFormat, HttpStatusCode statusCode) {
        return result -> {
            if (result != null) {
                response.setContent((InputStream)result.getOutput());
            }
            if (statusCode != null) {
                response.setStatusCode(statusCode.getStatusCode());
            }
            if (responseFormat != null) {
                response.setHeader("Content-Type", responseFormat.toContentTypeString());
            }
            if (response instanceof APIKitODataResponse) {
                ((APIKitODataResponse)response).setFlowAttributes((MultiMap<String, Object>)result.getAttributes().orElse(new MultiMap()));
            }
        };
    }
}

