/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.mule.extension.api.serialization.RawEntityCollectionSuccessResponse;
import org.mule.extension.internal.handlers.EntityCollectionResponseHandler;
import org.mule.extension.internal.handlers.RequestHandler;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.EntityCollectionRoutingManager;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class CollectionProcessor
implements EntityCollectionProcessor {
    private final EntityCollectionRoutingManager entityCollectionRoutingManager;
    private RequestHandler entityCollectionRequestHandler;
    private EntityCollectionResponseHandler entityCollectionResponseHandler;

    public CollectionProcessor(EntityCollectionRoutingManager entityCollectionRoutingManager) {
        this.entityCollectionRoutingManager = entityCollectionRoutingManager;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.entityCollectionRequestHandler = new RequestHandler(this.entityCollectionRoutingManager);
        this.entityCollectionResponseHandler = new EntityCollectionResponseHandler(odata, serviceMetadata);
    }

    public void readEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) {
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityCollectionRequestHandler.handleRequest(request, uriInfo);
        APIKitODataResponse apiKitResponse = OlingoUtils.getAPIKitResponse(response);
        CompletableFuture completableResult = routingContext.getFlowCompletableResponse();
        CompletionStage serialized = completableResult.thenApply(result -> {
            if (result instanceof RawEntityCollectionSuccessResponse) {
                RawEntityCollectionSuccessResponse rawResult = (RawEntityCollectionSuccessResponse)result;
                return Result.builder().output(rawResult.getRawContent().getValue()).mediaType(rawResult.getRawContent().getDataType().getMediaType()).attributes(rawResult.getFlowResponseMetadataProperties()).build();
            }
            return this.entityCollectionResponseHandler.serializeResponse(result, request, uriInfo, responseFormat);
        });
        routingContext.setOdataCompletableResponse((CompletableFuture<ODataResponse>)((CompletableFuture)serialized).thenApply(result -> {
            response.setContent((InputStream)result.getOutput());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", responseFormat.toContentTypeString());
            apiKitResponse.setFlowAttributes((MultiMap<String, Object>)result.getAttributes().orElse(new MultiMap()));
            return response;
        }));
        apiKitResponse.setRoutingContext(routingContext);
    }
}

