/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.exception;

import java.util.Locale;
import java.util.concurrent.CompletionException;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.search.SearchParserException;
import org.apache.olingo.server.core.uri.parser.search.SearchTokenizerException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.mule.extension.internal.exception.ODataDispatcherException;
import org.mule.extension.internal.exception.ODataModuleException;
import org.mule.extension.internal.exception.error.ODataError;
import org.mule.extension.internal.model.builders.ODataServerErrorBuilder;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class ODataExceptionHandler
extends ExceptionHandler {
    public Exception enrichException(Exception exception) {
        Throwable resultingThrowable = exception;
        if (exception instanceof CompletionException) {
            resultingThrowable = exception.getCause();
        }
        if (resultingThrowable instanceof ODataDispatcherException) {
            return this.handleException(((ODataDispatcherException)((Object)resultingThrowable)).getODataException(), Locale.ENGLISH);
        }
        if (resultingThrowable instanceof ODataException) {
            return this.handleException((ODataException)resultingThrowable, Locale.ENGLISH);
        }
        if (resultingThrowable.getCause() instanceof ODataException) {
            return this.handleException((ODataException)resultingThrowable.getCause(), Locale.ENGLISH);
        }
        org.mule.extension.api.error.ODataServerError serverError = ODataServerErrorBuilder.builder().withMessage(resultingThrowable.getMessage()).withStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).build();
        ODataError errorType = resultingThrowable instanceof ModuleException ? ((ModuleException)resultingThrowable).getType() : ODataError.INTERNAL_SERVER_ERROR;
        return new ODataModuleException(errorType, resultingThrowable, Message.builder().value((Object)serverError).build());
    }

    private ODataModuleException handleException(ODataException e, Locale requestedLocale) {
        ODataError errorType;
        ODataServerError serverError;
        if (e instanceof UriValidationException) {
            serverError = ODataExceptionHelper.createServerErrorObject((UriValidationException)((UriValidationException)e), (Locale)requestedLocale);
            errorType = ODataError.MALFORMED_URI;
        } else if (e instanceof UriParserSemanticException) {
            serverError = ODataExceptionHelper.createServerErrorObject((UriParserSemanticException)((UriParserSemanticException)e), (Locale)requestedLocale);
            errorType = ODataError.MALFORMED_URI;
        } else if (e instanceof SearchParserException || e instanceof SearchTokenizerException) {
            serverError = ODataExceptionHelper.createServerErrorObject((UriParserException)((UriParserException)e), (Locale)requestedLocale);
            errorType = ODataError.MALFORMED_SEARCH;
        } else if (e instanceof UriParserSyntaxException) {
            serverError = ODataExceptionHelper.createServerErrorObject((UriParserSyntaxException)((UriParserSyntaxException)e), (Locale)requestedLocale);
            errorType = ODataError.MALFORMED_URI;
        } else if (e instanceof UriParserException) {
            serverError = ODataExceptionHelper.createServerErrorObject((UriParserException)((UriParserException)e), (Locale)requestedLocale);
            errorType = ODataError.MALFORMED_URI;
        } else if (e instanceof ContentNegotiatorException) {
            serverError = ODataExceptionHelper.createServerErrorObject((ContentNegotiatorException)((ContentNegotiatorException)e), (Locale)requestedLocale);
            errorType = ODataError.NOT_IMPLEMENTED;
        } else if (e instanceof SerializerException) {
            serverError = ODataExceptionHelper.createServerErrorObject((SerializerException)((SerializerException)e), (Locale)requestedLocale);
            errorType = ODataError.SERIALIZATION;
        } else if (e instanceof BatchDeserializerException) {
            serverError = ODataExceptionHelper.createServerErrorObject((DeserializerException)((BatchDeserializerException)e), (Locale)requestedLocale);
            errorType = ODataError.DESERIALIZATION;
        } else if (e instanceof DeserializerException) {
            serverError = ODataExceptionHelper.createServerErrorObject((DeserializerException)((DeserializerException)e), (Locale)requestedLocale);
            errorType = ODataError.DESERIALIZATION;
        } else if (e instanceof ODataHandlerException) {
            serverError = ODataExceptionHelper.createServerErrorObject((ODataHandlerException)((ODataHandlerException)e), (Locale)requestedLocale);
            errorType = ODataError.INTERNAL_SERVER_ERROR;
        } else if (e instanceof ODataApplicationException) {
            ODataApplicationException applicationException = (ODataApplicationException)e;
            serverError = ODataExceptionHelper.createServerErrorObject((ODataApplicationException)applicationException);
            errorType = HttpStatusCode.NOT_FOUND.getStatusCode() == applicationException.getStatusCode() ? ODataError.NOT_FOUND : ODataError.INTERNAL_SERVER_ERROR;
        } else {
            serverError = ODataExceptionHelper.createServerErrorObject((Exception)e);
            errorType = ODataError.INTERNAL_SERVER_ERROR;
        }
        return new ODataModuleException(e.getMessage(), errorType, (Throwable)e, Message.builder().value((Object)ODataServerErrorBuilder.from(serverError)).build());
    }
}

