/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.api.tokenmanager;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.extension.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

@Alias(value="token-manager-config")
@TypeDsl(allowTopLevelDefinition=true)
@NoExtend
@NoInstantiate
public class TokenManagerConfig
implements Lifecycle,
MuleContextAware {
    public static AtomicInteger defaultTokenManagerConfigIndex = new AtomicInteger(0);
    private static final Map<String, TokenManagerConfig> activeConfigs = new ConcurrentHashMap<String, TokenManagerConfig>();
    @RefName
    private String name;
    @Parameter
    @Optional
    @ObjectStoreReference
    private ObjectStore<DefaultResourceOwnerOAuthContext> objectStore;
    private MuleContext muleContext;
    private ConfigOAuthContext configOAuthContext;
    private boolean initialised;
    private boolean started;

    public ObjectStore<DefaultResourceOwnerOAuthContext> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore<DefaultResourceOwnerOAuthContext> objectStore) {
        this.objectStore = objectStore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised) {
            return;
        }
        if (this.objectStore == null) {
            this.objectStore = this.muleContext.getObjectStoreManager().createObjectStore("token-manager-store-" + this.name, ObjectStoreSettings.builder().persistent(true).build());
        }
        this.configOAuthContext = new ConfigOAuthContext(this.muleContext.getLockFactory(), this.objectStore, this.name);
        this.initialised = true;
    }

    public void start() throws MuleException {
        if (!this.started) {
            LifecycleUtils.startIfNeeded(this.objectStore);
            this.started = true;
        }
    }

    public void stop() throws MuleException {
        if (this.started) {
            LifecycleUtils.stopIfNeeded(this.objectStore);
            this.started = false;
        }
    }

    public void dispose() {
        activeConfigs.remove(this.name);
    }

    public static TokenManagerConfig createDefault(MuleContext context) throws InitialisationException {
        TokenManagerConfig tokenManagerConfig = new TokenManagerConfig();
        String tokenManagerConfigName = "default-token-manager-config-" + defaultTokenManagerConfigIndex.getAndIncrement();
        tokenManagerConfig.setName(tokenManagerConfigName);
        activeConfigs.put(tokenManagerConfigName, tokenManagerConfig);
        return tokenManagerConfig;
    }

    public static TokenManagerConfig getTokenManagerConfigByName(String name) {
        return activeConfigs.get(name);
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.configOAuthContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenManagerConfig) {
            TokenManagerConfig other = (TokenManagerConfig)obj;
            return this.name.equals(other.name) && this.objectStore == other.objectStore;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.objectStore);
    }
}

