/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import java.util.Objects;
import org.mule.extension.oauth2.api.tokenmanager.TokenManagerConfig;
import org.mule.extension.oauth2.internal.service.OAuthContextServiceAdapter;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;

public class OAuthOperations {
    public void invalidateOauthContext(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        tokenManager.getConfigOAuthContext().clearContextForResourceOwner(resourceOwnerId);
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveAccessToken(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return OAuthContextServiceAdapter.getAccessToken(this.getContextForResourceOwner(tokenManager, resourceOwnerId));
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveRefreshToken(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return OAuthContextServiceAdapter.getRefreshToken(this.getContextForResourceOwner(tokenManager, resourceOwnerId));
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveExpiresIn(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return OAuthContextServiceAdapter.getExpiresIn(this.getContextForResourceOwner(tokenManager, resourceOwnerId));
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveState(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return OAuthContextServiceAdapter.getState(this.getContextForResourceOwner(tokenManager, resourceOwnerId));
    }

    @MediaType(value="text/plain", strict=false)
    public String retrieveCustomTokenResponseParam(@Expression(value=ExpressionSupport.NOT_SUPPORTED) TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId, String key) {
        return OAuthContextServiceAdapter.getTokenResponseParameters(this.getContextForResourceOwner(tokenManager, resourceOwnerId)).get(key).toString();
    }

    private void validateResourceOwnerId(String resourceOwnerId) {
        Objects.requireNonNull(resourceOwnerId, "Resource owner id cannot be null");
    }

    private Object getContextForResourceOwner(TokenManagerConfig tokenManager, String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return tokenManager.getConfigOAuthContext().getContextForResourceOwner(resourceOwnerId);
    }
}

