/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal.authorizationcode.state;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.mule.extension.oauth2.internal.store.SimpleObjectStoreToMapAdapter;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreToMapAdapter;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

public class ConfigOAuthContext {
    private final LockFactory lockFactory;
    private final String configName;
    private final ObjectStoreToMapAdapter<DefaultResourceOwnerOAuthContext> oauthContextStore;

    public ConfigOAuthContext(LockFactory lockFactory, ObjectStore<DefaultResourceOwnerOAuthContext> objectStore, String configName) {
        this.lockFactory = lockFactory;
        this.oauthContextStore = new SimpleObjectStoreToMapAdapter<DefaultResourceOwnerOAuthContext>(objectStore);
        this.configName = configName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        DefaultResourceOwnerOAuthContext resourceOwnerOAuthContext = null;
        if (!this.oauthContextStore.containsKey((Object)resourceOwnerId)) {
            Lock lock = this.lockFactory.createLock(this.configName + "-config-oauth-context");
            lock.lock();
            try {
                if (!this.oauthContextStore.containsKey((Object)resourceOwnerId)) {
                    resourceOwnerOAuthContext = new DefaultResourceOwnerOAuthContext(this.createLockForResourceOwner(resourceOwnerId), resourceOwnerId);
                    this.oauthContextStore.put(resourceOwnerId, (Serializable)resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null) {
            resourceOwnerOAuthContext = (DefaultResourceOwnerOAuthContext)this.oauthContextStore.get((Object)resourceOwnerId);
            resourceOwnerOAuthContext.setRefreshUserOAuthContextLock(this.createLockForResourceOwner(resourceOwnerId));
        }
        return resourceOwnerOAuthContext;
    }

    private Lock createLockForResourceOwner(String resourceOwnerId) {
        return this.lockFactory.createLock(this.configName + "-" + resourceOwnerId);
    }

    public void updateResourceOwnerOAuthContext(DefaultResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock();
        resourceOwnerContextLock.lock();
        try {
            this.oauthContextStore.put(resourceOwnerOAuthContext.getResourceOwnerId(), (Serializable)resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }

    public void clearContextForResourceOwner(String resourceOwnerId) {
        DefaultResourceOwnerOAuthContext resourceOwnerOAuthContext = this.getContextForResourceOwner(resourceOwnerId);
        if (resourceOwnerOAuthContext != null) {
            resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().lock();
            try {
                this.oauthContextStore.remove((Object)resourceOwnerId);
            }
            finally {
                resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
            }
        }
    }
}

