/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.xml.util.LocalResourceResolverInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class MuleResourceResolver
implements LSResourceResolver {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseUri) {
        try {
            this.logger.debug("Resolving resource : " + systemId);
            return this.obtainInputStream(type, namespaceURI, publicId, systemId, baseUri);
        }
        catch (Exception e) {
            this.logger.debug("Cannot resolve resource " + systemId + " with LocalResourceResolver");
            return null;
        }
    }

    private LSInput obtainInputStream(String type, String namespaceURI, String publicId, String systemId, String baseUri) throws URISyntaxException, IOException {
        String resource = this.resolveUri(systemId, baseUri);
        LocalResourceResolverInput input = new LocalResourceResolverInput();
        InputStream stream = IOUtils.getResourceAsStream((String)resource, this.getClass());
        if (stream == null) {
            return null;
        }
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setBaseURI(baseUri);
        input.setByteStream(stream);
        return input;
    }

    private String resolveUri(String systemId, String baseURI) throws URISyntaxException {
        String resource;
        if (StringUtils.isNotBlank((String)baseURI)) {
            URI baseUriObject = new URI(baseURI);
            URI absoluteUri = baseUriObject.resolve(systemId);
            resource = absoluteUri.toASCIIString();
        } else {
            resource = systemId;
        }
        return resource;
    }
}

