/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.filters;

import javax.xml.parsers.DocumentBuilderFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.module.xml.transformer.XmlToDomDocument;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractJaxpFilter {
    private XmlToDomDocument xmlToDom = new XmlToDomDocument();
    private DocumentBuilderFactory documentBuilderFactory;

    public AbstractJaxpFilter() {
        this.xmlToDom.setReturnDataType(DataType.fromType(Document.class));
    }

    public void initialise() throws InitialisationException {
        if (this.getDocumentBuilderFactory() == null) {
            DocumentBuilderFactory builderFactory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
            builderFactory.setNamespaceAware(true);
            this.setDocumentBuilderFactory(builderFactory);
        }
    }

    @Deprecated
    public Node toDOMNode(Object src) throws Exception {
        return this.toDOMNode(src, Event.getCurrentEvent());
    }

    public Node toDOMNode(Object src, Event event) throws Exception {
        Node node = XMLUtils.toDOMNode(src, event, this.getDocumentBuilderFactory());
        return node == null ? (Node)this.xmlToDom.transform(src) : node;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }
}

