/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamFactory {
    public static final String XSTREAM_DOM_DRIVER = "com.thoughtworks.xstream.io.xml.DomDriver";
    public static final String XSTREAM_DOM4J_DRIVER = "com.thoughtworks.xstream.io.xml.Dom4JDriver";
    public static final String XSTREAM_JDOM_DRIVER = "com.thoughtworks.xstream.io.xml.JDomDriver";
    public static final String XSTREAM_STAX_DRIVER = "com.thoughtworks.xstream.io.xml.StaxDriver";
    public static final String XSTREAM_XPP_DRIVER = "com.thoughtworks.xstream.io.xml.XppDriver";
    private static final Logger logger = LoggerFactory.getLogger(XStreamFactory.class);
    private final XStream xstream;

    public XStreamFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(XSTREAM_XPP_DRIVER, null, null);
    }

    public XStreamFactory(String driverClassName, Map<String, Class<?>> aliases, Set<Class<? extends Converter>> converters) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class driverClass = ClassUtils.loadClass((String)driverClassName, this.getClass());
        this.xstream = new XStream((HierarchicalStreamDriver)driverClass.newInstance());
        this.xstream.registerConverter((Converter)new ConcurrentHashMapConverter(this.xstream.getMapper()), -1);
        this.registerAliases(aliases);
        this.registerConverters(converters);
    }

    private void registerAliases(Map<String, Class<?>> aliases) {
        if (aliases != null) {
            for (Map.Entry<String, Class<?>> entry : aliases.entrySet()) {
                this.xstream.alias(entry.getKey(), entry.getValue());
            }
        }
    }

    private void registerConverters(Set<Class<? extends Converter>> converters) throws InstantiationException, IllegalAccessException {
        if (converters != null) {
            for (Class<? extends Converter> converter : converters) {
                Converter converterInstance = converter.newInstance();
                if (converterInstance instanceof Converter) {
                    this.xstream.registerConverter(converterInstance);
                    continue;
                }
                if (converterInstance instanceof SingleValueConverter) {
                    this.xstream.registerConverter((SingleValueConverter)converterInstance);
                    continue;
                }
                logger.warn("Invalid converter class specified - ignoring: " + converter.getName());
            }
        }
    }

    public final XStream getInstance() {
        return this.xstream;
    }

    private class ConcurrentHashMapConverter
    extends MapConverter {
        public ConcurrentHashMapConverter(Mapper mapper) throws ClassNotFoundException {
            super(mapper);
        }

        public boolean canConvert(Class aClass) {
            String className = aClass.getName();
            return className.equals("java.util.concurrent.ConcurrentHashMap");
        }
    }
}

