/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer.datatype;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.metadata.SimpleDataType;
import org.mule.runtime.core.util.ClassUtils;

public class SimpleDataTypeXStreamConverter
implements Converter {
    public boolean canConvert(Class type) {
        return SimpleDataType.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SimpleDataType dataType = (SimpleDataType)source;
        writer.addAttribute("type", dataType.getType().getName());
        writer.addAttribute("mediaType", dataType.getMediaType().toRfcString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type;
        try {
            type = ClassUtils.getClass((String)reader.getAttribute("type"));
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        String mediaType = reader.getAttribute("mediaType");
        return this.createDataType(type, mediaType);
    }

    protected SimpleDataType createDataType(Class<?> type, String mimeType) {
        return (SimpleDataType)DataType.builder().type(type).mediaType(mimeType).build();
    }
}

