/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.stax;

import java.util.ArrayList;
import java.util.List;
import javanet.staxutils.events.AttributeEvent;
import javanet.staxutils.events.CDataEvent;
import javanet.staxutils.events.CharactersEvent;
import javanet.staxutils.events.CommentEvent;
import javanet.staxutils.events.EndDocumentEvent;
import javanet.staxutils.events.EndElementEvent;
import javanet.staxutils.events.NamespaceEvent;
import javanet.staxutils.events.StartDocumentEvent;
import javanet.staxutils.events.StartElementEvent;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.mule.module.xml.stax.DelegateXMLStreamReader;
import org.mule.module.xml.stax.MapNamespaceContext;
import org.mule.module.xml.stax.StartElementEventX;

public class ReversibleXMLStreamReader
extends DelegateXMLStreamReader {
    private List events;
    private XMLEvent current;
    private int replayIndex;
    private boolean tracking = false;
    private boolean replay = false;

    public ReversibleXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void reset() {
        this.replay = true;
        this.replayIndex = 0;
        this.current = null;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
        if (tracking) {
            this.replayIndex = 0;
            if (this.events == null) {
                this.events = new ArrayList();
            }
        }
    }

    public int next() throws XMLStreamException {
        int event;
        if (this.replay) {
            if (this.replayIndex == this.events.size()) {
                this.replay = false;
                event = super.next();
            } else {
                event = this.getReplayEvent();
            }
        } else {
            event = super.next();
        }
        if (this.tracking && !this.replay) {
            this.capture(event);
        }
        return event;
    }

    private int getReplayEvent() {
        this.current = (XMLEvent)this.events.get(this.replayIndex);
        ++this.replayIndex;
        return this.current.getEventType();
    }

    private void capture(int event) {
        switch (event) {
            case 7: {
                this.events.add(new StartDocumentEvent(this.getEncoding(), new Boolean(this.isStandalone()), this.getVersion(), this.getLocation()));
                break;
            }
            case 8: {
                this.events.add(new EndDocumentEvent(this.getLocation()));
                break;
            }
            case 1: {
                this.events.add(this.createStartElementEvent());
                break;
            }
            case 2: {
                this.events.add(new EndElementEvent(this.getName(), this.getNamespaces().iterator(), this.getLocation()));
                break;
            }
            case 12: {
                this.events.add(new CDataEvent(this.getText(), this.getLocation()));
                break;
            }
            case 4: {
                this.events.add(new CharactersEvent(this.getText(), this.getLocation()));
                break;
            }
            case 5: {
                this.events.add(new CommentEvent(this.getText(), this.getLocation()));
                break;
            }
            case 11: {
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private StartElementEvent createStartElementEvent() {
        ArrayList<AttributeEvent> attributes = new ArrayList<AttributeEvent>();
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            attributes.add(new AttributeEvent(this.getAttributeName(i), this.getAttributeValue(i)));
        }
        return new StartElementEventX(this.getName(), attributes, this.getNamespaces(), this.createContext(), this.getLocation(), null);
    }

    private NamespaceContext createContext() {
        MapNamespaceContext ctx = new MapNamespaceContext();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            ctx.addNamespace(this.getNamespacePrefix(i), this.getNamespaceURI(i));
        }
        return ctx;
    }

    private List getNamespaces() {
        ArrayList<NamespaceEvent> namespaces = new ArrayList<NamespaceEvent>();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            namespaces.add(new NamespaceEvent(this.getNamespacePrefix(i), this.getNamespaceURI(i), this.getLocation()));
        }
        return namespaces;
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuffer buf = new StringBuffer();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                buf.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return buf.toString();
    }

    public int getAttributeCount() {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getAttributeList().size();
        }
        return super.getAttributeCount();
    }

    public String getAttributeLocalName(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getLocalPart();
        }
        return super.getAttributeLocalName(i);
    }

    public QName getAttributeName(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName();
        }
        return super.getAttributeName(i);
    }

    public String getAttributeNamespace(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getNamespaceURI();
        }
        return super.getAttributeNamespace(i);
    }

    public String getAttributePrefix(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getName().getPrefix();
        }
        return super.getAttributePrefix(i);
    }

    public String getAttributeType(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getDTDType();
        }
        return super.getAttributeType(i);
    }

    public String getAttributeValue(int i) {
        if (this.replay) {
            Attribute att = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return att.getValue();
        }
        return super.getAttributeValue(i);
    }

    public String getAttributeValue(String ns, String local) {
        if (this.replay) {
            Attribute att = ((StartElementEventX)((Object)this.current)).getAttributeByName(new QName(ns, local));
            if (att != null) {
                return att.getValue();
            }
            return null;
        }
        return super.getAttributeValue(ns, local);
    }

    public int getEventType() {
        if (this.replay) {
            if (this.current == null) {
                return 7;
            }
            return this.current.getEventType();
        }
        return super.getEventType();
    }

    public String getLocalName() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getLocalPart();
            }
            return ((EndElementEvent)this.current).getName().getLocalPart();
        }
        return super.getLocalName();
    }

    public Location getLocation() {
        if (this.replay) {
            return this.current.getLocation();
        }
        return super.getLocation();
    }

    public QName getName() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName();
            }
            return ((EndElementEvent)this.current).getName();
        }
        return super.getName();
    }

    public NamespaceContext getNamespaceContext() {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getNamespaceContext();
        }
        return super.getNamespaceContext();
    }

    public int getNamespaceCount() {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getNamespaceList().size();
        }
        return super.getNamespaceCount();
    }

    public String getNamespacePrefix(int arg0) {
        if (this.replay) {
            Namespace ns = (Namespace)((StartElementEventX)((Object)this.current)).getNamespaceList().get(arg0);
            return ns.getPrefix();
        }
        return super.getNamespacePrefix(arg0);
    }

    public String getNamespaceURI() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getNamespaceURI();
            }
            return ((EndElementEvent)this.current).getName().getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    public String getNamespaceURI(int arg0) {
        if (this.replay) {
            Namespace ns = (Namespace)((StartElementEventX)((Object)this.current)).getNamespaceList().get(arg0);
            return ns.getNamespaceURI();
        }
        return super.getNamespaceURI(arg0);
    }

    public String getNamespaceURI(String prefix) {
        if (this.replay) {
            return ((StartElementEventX)((Object)this.current)).getNamespaceURI(prefix);
        }
        return super.getNamespaceURI(prefix);
    }

    public String getPIData() {
        if (this.replay) {
            return null;
        }
        return super.getPIData();
    }

    public String getPITarget() {
        if (this.replay) {
            return null;
        }
        return super.getPITarget();
    }

    public String getPrefix() {
        if (this.replay) {
            if (this.isStartElement()) {
                return ((StartElementEventX)((Object)this.current)).getName().getPrefix();
            }
            return ((EndElementEvent)this.current).getName().getPrefix();
        }
        return super.getPrefix();
    }

    public String getText() {
        if (this.replay) {
            if (this.current instanceof CommentEvent) {
                return ((CommentEvent)this.current).getText();
            }
            return ((CharactersEvent)this.current).getData();
        }
        return super.getText();
    }

    public char[] getTextCharacters() {
        if (this.replay) {
            return ((CharactersEvent)this.current).getData().toCharArray();
        }
        return super.getTextCharacters();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.replay) {
            char[] src = this.getText().toCharArray();
            if (sourceStart + length >= src.length) {
                length = src.length - sourceStart;
            }
            for (int i = 0; i < length; ++i) {
                target[targetStart + i] = src[i + sourceStart];
            }
            return length;
        }
        return super.getTextCharacters(sourceStart, target, targetStart, length);
    }

    public int getTextLength() {
        if (this.replay) {
            return this.getText().length();
        }
        return super.getTextLength();
    }

    public int getTextStart() {
        if (this.replay) {
            return 0;
        }
        return super.getTextStart();
    }

    public boolean hasName() {
        if (this.replay) {
            return this.isStartElement() || this.isEndElement();
        }
        return super.hasName();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.replay) {
            if (this.replayIndex == this.events.size()) {
                return super.hasNext();
            }
            return true;
        }
        return super.hasNext();
    }

    public boolean hasText() {
        if (this.replay) {
            int event = this.getEventType();
            return event == 4 || event == 11 || event == 9 || event == 5 || event == 6;
        }
        return super.hasText();
    }

    public boolean isAttributeSpecified(int i) {
        if (this.replay) {
            Attribute attr = (Attribute)((StartElementEventX)((Object)this.current)).getAttributeList().get(i);
            return attr.isSpecified();
        }
        return super.isAttributeSpecified(i);
    }

    public boolean isCharacters() {
        if (this.replay) {
            return this.current.isCharacters();
        }
        return super.isCharacters();
    }

    public boolean isEndElement() {
        if (this.replay) {
            return this.current.isEndElement();
        }
        return super.isEndElement();
    }

    public boolean isStartElement() {
        if (this.replay) {
            return this.current.isStartElement();
        }
        return super.isStartElement();
    }

    public boolean isWhiteSpace() {
        if (this.replay) {
            return this.current.getEventType() == 6;
        }
        return super.isWhiteSpace();
    }
}

