/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.context.notification.MuleContextNotification;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.stax.MapNamespaceContext;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Node;

public class JaxpXPathExpressionEvaluator
implements ExpressionEvaluator,
Initialisable,
Disposable,
MuleContextAware {
    private Map cache = new WeakHashMap(8);
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;
    private QName returnType = XPathConstants.STRING;

    public String getName() {
        return "xpath2";
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        try {
            this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                public void onNotification(MuleContextNotification notification) {
                    if (103 == notification.getAction()) {
                        try {
                            JaxpXPathExpressionEvaluator.this.namespaceManager = (NamespaceManager)JaxpXPathExpressionEvaluator.this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
                        }
                        catch (RegistrationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            throw new InitialisationException(t, (Initialisable)this);
        }
    }

    public Object evaluate(String expression, MuleMessage message) {
        QName retType = this.returnType;
        if (expression.startsWith("[")) {
            int x = expression.indexOf("]");
            if (x == -1) {
                throw new IllegalArgumentException("Expression is malformed: " + expression);
            }
            String type = expression.substring(1, x);
            expression = expression.substring(x + 1);
            if (type.equalsIgnoreCase("boolean")) {
                retType = XPathConstants.BOOLEAN;
            } else if (type.equalsIgnoreCase("string")) {
                retType = XPathConstants.STRING;
            } else if (type.equalsIgnoreCase("node")) {
                retType = XPathConstants.NODE;
            } else if (type.equalsIgnoreCase("nodeset")) {
                retType = XPathConstants.NODESET;
            } else if (type.equalsIgnoreCase("number")) {
                retType = XPathConstants.NUMBER;
            } else {
                throw new IllegalArgumentException("Result type not recognised: " + type + ". Use either boolean, string, number, node or nodeset.");
            }
        }
        try {
            Node payload = (Node)message.getPayload(DataTypeFactory.create(Node.class));
            XPathExpression xpath = this.getXPath(expression);
            return xpath.evaluate(payload, retType);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(XmlMessages.failedToProcessXPath(expression), (Throwable)e);
        }
    }

    public final void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected XPathExpression getXPath(String expression) throws XPathExpressionException {
        XPathExpression xpath = (XPathExpression)this.cache.get(expression + this.getClass().getName());
        if (xpath == null) {
            xpath = this.createXPath(expression);
            this.cache.put(expression + this.getClass().getName(), xpath);
        }
        return xpath;
    }

    protected XPathExpression createXPath(String expression) throws XPathExpressionException {
        XPath xp = XPathFactory.newInstance().newXPath();
        if (this.getNamespaceManager() != null) {
            xp.setNamespaceContext(new MapNamespaceContext(this.getNamespaceManager().getNamespaces()));
        }
        return xp.compile(expression);
    }

    public void dispose() {
        this.cache.clear();
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public QName getReturnType() {
        return this.returnType;
    }

    public void setReturnType(QName returnType) {
        this.returnType = returnType;
    }
}

