/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.dom.DOMDocument;
import org.mule.RequestContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.OutputHandler;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractJaxpFilter {
    private XmlToDomDocument xmlToDom = new XmlToDomDocument();
    private DocumentBuilderFactory documentBuilderFactory;

    public AbstractJaxpFilter() {
        this.xmlToDom.setReturnClass(org.w3c.dom.Document.class);
    }

    public void initialise() throws InitialisationException {
        if (this.getDocumentBuilderFactory() == null) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            this.setDocumentBuilderFactory(builderFactory);
        }
    }

    public Node toDOMNode(Object src) throws Exception {
        if (src instanceof Node) {
            return (org.w3c.dom.Document)src;
        }
        if (src instanceof Document) {
            Document dom4j = (Document)src;
            DOMDocument dom = new DOMDocument();
            dom.setDocument(dom4j);
            return dom;
        }
        if (src instanceof OutputHandler) {
            OutputHandler handler = (OutputHandler)src;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            handler.write(RequestContext.getEvent(), (OutputStream)output);
            ByteArrayInputStream stream = new ByteArrayInputStream(output.toByteArray());
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse(stream);
        }
        if (src instanceof byte[]) {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])src);
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse(stream);
        }
        if (src instanceof InputStream) {
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse((InputStream)src);
        }
        if (src instanceof String) {
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(new StringReader((String)src)));
        }
        if (src instanceof XMLStreamReader) {
            XMLStreamReader xsr = (XMLStreamReader)src;
            if (!xsr.isStartElement() && xsr.getEventType() != 7) {
                xsr.nextTag();
            }
            return this.getDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource());
        }
        if (src instanceof DelayedResult) {
            DelayedResult result = (DelayedResult)src;
            DOMResult domResult = new DOMResult();
            result.write(domResult);
            return domResult.getNode();
        }
        return (Node)this.xmlToDom.transform(src);
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }
}

