/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.routing;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.AbstractRoundRobinMessageSplitter;
import org.mule.util.ExceptionUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class XmlMessageSplitter
extends AbstractRoundRobinMessageSplitter {
    public static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String JAXP_PROPERTIES_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE = "http://www.w3.org/2001/XMLSchema";
    protected volatile String splitExpression = "";
    protected volatile Map namespaces = null;
    protected volatile boolean validateSchema = false;
    protected volatile String externalSchemaLocation = "";

    public void setSplitExpression(String splitExpression) {
        this.splitExpression = StringUtils.trimToEmpty((String)splitExpression);
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public Map getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    public String getSplitExpression() {
        return this.splitExpression;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public String getExternalSchemaLocation() {
        return this.externalSchemaLocation;
    }

    public void setExternalSchemaLocation(String externalSchemaLocation) {
        this.externalSchemaLocation = externalSchemaLocation;
    }

    public void initialise() throws InitialisationException {
        if (StringUtils.isBlank((String)this.splitExpression)) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"splitExpression").getMessage());
        }
        super.initialise();
    }

    protected List splitMessage(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            if (this.splitExpression.length() == 0) {
                this.logger.warn((Object)"splitExpression is not specified, no processing will take place");
            } else {
                this.logger.debug((Object)("splitExpression is " + this.splitExpression));
            }
        }
        Object src = message.getPayload();
        try {
            Document dom4jDoc;
            if (src instanceof byte[]) {
                src = new String((byte[])src);
            }
            if (src instanceof String) {
                String xml = (String)src;
                SAXReader reader = new SAXReader();
                this.setDoSchemaValidation(reader, this.isValidateSchema());
                dom4jDoc = reader.read((Reader)new StringReader(xml));
            } else if (src instanceof Document) {
                dom4jDoc = (Document)src;
            } else if (src instanceof org.w3c.dom.Document) {
                DOMReader xmlReader = new DOMReader();
                dom4jDoc = xmlReader.read((org.w3c.dom.Document)src);
            } else {
                throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(src.getClass(), (Class[])new Class[]{org.w3c.dom.Document.class, Document.class, String.class, byte[].class}).getMessage());
            }
            XPath xpath = dom4jDoc.createXPath(this.splitExpression);
            if (this.namespaces != null) {
                xpath.setNamespaceURIs(this.namespaces);
            }
            List foundNodes = xpath.selectNodes((Object)dom4jDoc);
            if (this.enableCorrelation != 2) {
                message.setCorrelationGroupSize(foundNodes.size());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Split into " + foundNodes.size()));
            }
            LinkedList<Document> parts = new LinkedList<Document>();
            for (Node node : foundNodes) {
                if (node instanceof Element) {
                    node = (Node)node.clone();
                    parts.add(DocumentHelper.createDocument((Element)((Element)node)));
                    continue;
                }
                this.logger.warn((Object)("Dcoument node: " + node.asXML() + " is not an element and thus is not a valid part"));
            }
            return parts;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to initialise the payload: " + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    protected void setDoSchemaValidation(SAXReader reader, boolean validate) throws Exception {
        reader.setValidation(validate);
        reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA, validate);
        reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING, true);
        if (!validate) {
            return;
        }
        InputStream xsdAsStream = IOUtils.getResourceAsStream((String)this.getExternalSchemaLocation(), ((Object)((Object)this)).getClass());
        if (xsdAsStream == null) {
            throw new IllegalArgumentException("Couldn't find schema at " + this.getExternalSchemaLocation());
        }
        reader.setProperty(JAXP_PROPERTIES_SCHEMA_LANGUAGE, (Object)JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE);
        reader.setProperty(JAXP_PROPERTIES_SCHEMA_SOURCE, (Object)xsdAsStream);
    }
}

