/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.AbstractTransformer;

public class JXPathExtractor
extends AbstractTransformer {
    private volatile String expression;
    private volatile boolean singleResult = true;

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            ArrayList result;
            Document doc = XMLUtils.toDocument(src);
            if (doc != null) {
                if (this.singleResult) {
                    result = doc.valueOf(this.expression);
                } else {
                    XPath xpath = doc.createXPath(this.expression);
                    List obj = (List)xpath.evaluate((Object)doc);
                    result = new ArrayList(obj.size());
                    for (int i = 0; i < obj.size(); ++i) {
                        Node node = (Node)obj.get(i);
                        ((List)result).add(node.getText());
                    }
                }
            } else {
                JXPathContext context = JXPathContext.newContext((Object)src);
                result = context.getValue(this.expression);
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean isSingleResult() {
        return this.singleResult;
    }

    public void setSingleResult(boolean singleResult) {
        this.singleResult = singleResult;
    }
}

