/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.AbstractTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXmlTransformer
extends AbstractTransformer {
    private String outputEncoding;

    public AbstractXmlTransformer() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(DocumentSource.class);
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Element.class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(byte[].class);
    }

    public Source getXmlSource(Object src) {
        if (src instanceof byte[]) {
            return new StreamSource(new ByteArrayInputStream((byte[])src));
        }
        if (src instanceof InputStream) {
            return new StreamSource((InputStream)src);
        }
        if (src instanceof String) {
            return new StreamSource(new StringReader((String)src));
        }
        if (src instanceof DocumentSource) {
            return (Source)src;
        }
        if (src instanceof Document) {
            return new DocumentSource((Document)src);
        }
        if (src instanceof org.w3c.dom.Document || src instanceof Element) {
            return new DOMSource((Node)src);
        }
        return null;
    }

    protected static ResultHolder getResultHolder(Class desiredClass) {
        if (desiredClass == null) {
            return null;
        }
        if (byte[].class.equals((Object)desiredClass) || InputStream.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult((OutputStream)this.resultStream);

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.resultStream.toByteArray();
                }
            };
        }
        if (String.class.equals((Object)desiredClass)) {
            return new ResultHolder(){
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(this.writer);

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.writer.getBuffer().toString();
                }
            };
        }
        if (org.w3c.dom.Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DOMResult result = new DOMResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result.getNode();
                }
            };
        }
        if (DocumentResult.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result;
                }
            };
        }
        if (Document.class.isAssignableFrom(desiredClass)) {
            return new ResultHolder(){
                DocumentResult result = new DocumentResult();

                public Result getResult() {
                    return this.result;
                }

                public Object getResultObject() {
                    return this.result.getDocument();
                }
            };
        }
        return null;
    }

    protected String convertToText(Object obj) throws TransformerFactoryConfigurationError, TransformerException {
        return this.convertToText(obj, null);
    }

    protected String convertToText(Object obj, String outputEncoding) throws TransformerFactoryConfigurationError, TransformerException {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Document) {
            return ((Document)obj).asXML();
        }
        Source src = this.getXmlSource(obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
        if (outputEncoding != null) {
            idTransformer.setOutputProperty("encoding", outputEncoding);
        }
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    protected String convertToBytes(Object obj, String outputEncoding) throws TransformerFactoryConfigurationError, TransformerException {
        Source src = this.getXmlSource(obj);
        if (src == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer idTransformer = XMLUtils.getTransformer();
        idTransformer.setOutputProperty("encoding", outputEncoding);
        idTransformer.transform(src, result);
        return writer.getBuffer().toString();
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    protected static interface ResultHolder {
        public Result getResult();

        public Object getResultObject();
    }
}

