/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformers.xml.AbstractXStreamTransformer;
import org.mule.transformers.xml.DomDocumentToXml;

public class XmlToObject
extends AbstractXStreamTransformer {
    private final DomDocumentToXml domTransformer = new DomDocumentToXml();

    public XmlToObject() {
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Document.class);
        this.setReturnClass(Object.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        if (src instanceof byte[]) {
            try {
                InputStreamReader xml = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])src), outputEncoding);
                return this.getXStream().fromXML((Reader)xml);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException((Transformer)this, (Throwable)uee);
            }
        }
        if (src instanceof String) {
            return this.getXStream().fromXML(src.toString());
        }
        return this.getXStream().fromXML((String)this.domTransformer.transform(src));
    }
}

