/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformers.xml.AbstractXmlTransformer;

public class DocumentToOutputHandler
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public DocumentToOutputHandler() {
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.setReturnClass(OutputHandler.class);
    }

    public Object doTransform(final Object src, final String encoding) throws TransformerException {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    out.write(DocumentToOutputHandler.this.convertToBytes(src, encoding).getBytes());
                }
                catch (javax.xml.transform.TransformerException e) {
                    throw new IOException(e.toString());
                }
            }
        };
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

