/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import java.io.OutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.transformers.xml.XsltTransformer;
import org.mule.xml.util.XMLUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsltTransformerDefinitionParser
extends MuleOrphanDefinitionParser {
    public static final String STYLESHEET = "stylesheet";
    public static final int UNDEFINED = -1;

    public XsltTransformerDefinitionParser() {
        super(XsltTransformer.class, false);
        this.addAlias("transformerFactoryClass", "xslTransformerFactory");
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        NodeList children = element.getChildNodes();
        if (0 != children.getLength()) {
            Node stylesheet = null;
            for (int i = 0; i < children.getLength(); ++i) {
                if (1 != children.item(i).getNodeType()) continue;
                this.assertArgument(null == stylesheet, "XSLT transformer can have at most one child element");
                stylesheet = (Element)children.item(i);
            }
            if (null != stylesheet) {
                this.assertArgument(STYLESHEET.equals(stylesheet.getLocalName()), "XSLT transformer child element must be named stylesheet");
                assembler.extendBean("xslt", (Object)this.domToString((Element)stylesheet), false);
                element.removeChild(stylesheet);
            }
        }
        super.postProcess(context, assembler, element);
    }

    protected String domToString(Element dom) {
        try {
            DOMSource source = new DOMSource(dom);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult result = new StreamResult((OutputStream)output);
            XMLUtils.getTransformer().transform(source, result);
            return output.toString();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
        }
    }

    protected void assertArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

