/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.util.IOUtils;
import org.xml.sax.SAXException;

public class FilteringXmlMessageSplitter
extends AbstractMessageSplitter {
    private static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String JAXP_PROPERTIES_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE = "http://www.w3.org/2001/XMLSchema";
    protected static ThreadLocal properties = new ThreadLocal();
    protected static ThreadLocal nodes = new ThreadLocal();
    protected String splitExpression = "";
    protected Map namespaces = null;
    protected boolean validateSchema = false;
    protected String externalSchemaLocation = "";

    public void setSplitExpression(String splitExpression) {
        this.splitExpression = splitExpression;
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public String getSplitExpression() {
        return this.splitExpression;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public String getExternalSchemaLocation() {
        return this.externalSchemaLocation;
    }

    public void setExternalSchemaLocation(String externalSchemaLocation) {
        this.externalSchemaLocation = externalSchemaLocation;
    }

    protected void initialise(UMOMessage message) {
        this.splitExpression = this.splitExpression.trim();
        if (this.logger.isDebugEnabled()) {
            if (this.splitExpression.length() == 0) {
                this.logger.warn((Object)"splitExpression is not specified, no processing will take place");
            } else {
                this.logger.debug((Object)("splitExpression is " + this.splitExpression));
            }
        }
        Object src = message.getPayload();
        try {
            Document dom4jDoc;
            if (src instanceof byte[]) {
                src = new String((byte[])src);
            }
            if (src instanceof String) {
                String xml = (String)src;
                SAXReader reader = new SAXReader();
                this.setDoSchemaValidation(reader, this.isValidateSchema());
                InputStream xsdAsStream = IOUtils.getResourceAsStream((String)this.getExternalSchemaLocation(), ((Object)((Object)this)).getClass());
                if (xsdAsStream == null) {
                    throw new IllegalArgumentException("Couldn't find schema at " + this.getExternalSchemaLocation());
                }
                reader.setProperty(JAXP_PROPERTIES_SCHEMA_LANGUAGE, (Object)JAXP_PROPERTIES_SCHEMA_LANGUAGE_VALUE);
                reader.setProperty(JAXP_PROPERTIES_SCHEMA_SOURCE, (Object)xsdAsStream);
                dom4jDoc = reader.read((Reader)new StringReader(xml));
            } else if (src instanceof Document) {
                dom4jDoc = (Document)src;
            } else {
                this.logger.error((Object)("Non-xml message payload: " + src.getClass().toString()));
                return;
            }
            if (dom4jDoc != null) {
                if (this.splitExpression.length() > 0) {
                    XPath xpath = dom4jDoc.createXPath(this.splitExpression);
                    if (this.namespaces != null) {
                        xpath.setNamespaceURIs(this.namespaces);
                    }
                    List foundNodes = xpath.selectNodes((Object)dom4jDoc);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Split into " + foundNodes.size()));
                    }
                    ArrayList<Document> parts = new ArrayList<Document>();
                    Iterator iterator = foundNodes.iterator();
                    while (iterator.hasNext()) {
                        Node node = (Node)iterator.next();
                        if (node instanceof Element) {
                            node = (Node)node.clone();
                            parts.add(DocumentHelper.createDocument((Element)((Element)node)));
                            continue;
                        }
                        this.logger.warn((Object)("Dcoument node: " + node.asXML() + " is not an element and thus is not a valid part"));
                    }
                    nodes.set(parts);
                }
            } else {
                this.logger.warn((Object)"Unsupported message type, ignoring");
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to initialise the payload: " + ExceptionUtils.getStackTrace((Throwable)ex));
        }
        HashMap<String, Object> theProperties = new HashMap<String, Object>();
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            theProperties.put(propertyKey, message.getProperty(propertyKey));
        }
        properties.set(theProperties);
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        List nodes = (List)FilteringXmlMessageSplitter.nodes.get();
        if (nodes == null) {
            this.logger.error((Object)"Error: nodes are null");
            return null;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Document doc = (Document)nodes.get(i);
            try {
                Map theProperties = (Map)properties.get();
                MuleMessage result = new MuleMessage((Object)doc, new HashMap(theProperties));
                if (endpoint.getFilter() == null || endpoint.getFilter().accept((UMOMessage)result)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Endpoint filter matched for node " + i + " of " + nodes.size() + ". Routing message over: " + endpoint.getEndpointURI().toString()));
                    }
                    nodes.remove(i);
                    return result;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Endpoint filter did not match, returning null");
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create message for node at position " + i), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void setDoSchemaValidation(SAXReader reader, boolean validate) throws SAXException {
        reader.setValidation(validate);
        reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA, validate);
        reader.setFeature(APACHE_XML_FEATURES_VALIDATION_SCHEMA_FULL_CHECKING, true);
    }
}

