/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.mule.config.i18n.Message;
import org.mule.transformers.xml.AbstractXmlTransformer;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.IOUtils;

public class XsltTransformer
extends AbstractXmlTransformer {
    private static final long serialVersionUID = -6958917343589717387L;
    private ObjectPool transformerPool;
    private int maxIdleTransformers = 2;
    private String xslFile;
    private String xslt;
    private static final int MIN_IDLE = 1;

    public void initialise() throws InitialisationException {
        try {
            this.transformerPool = new StackObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                public Object makeObject() throws Exception {
                    StreamSource source = XsltTransformer.this.getStreamSource();
                    TransformerFactory factory = TransformerFactory.newInstance();
                    return factory.newTransformer(source);
                }
            }, Math.max(1, this.maxIdleTransformers));
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object result;
            Source sourceDoc = this.getXmlSource(src);
            if (sourceDoc == null) {
                return null;
            }
            AbstractXmlTransformer.ResultHolder holder = XsltTransformer.getResultHolder(this.returnClass);
            if (holder == null) {
                holder = XsltTransformer.getResultHolder(src.getClass());
            }
            DefaultErrorListener errorListener = new DefaultErrorListener((UMOTransformer)this);
            Transformer transformer = null;
            try {
                transformer = (Transformer)this.transformerPool.borrowObject();
                transformer.setErrorListener(errorListener);
                transformer.setOutputProperty("encoding", encoding);
                transformer.transform(sourceDoc, holder.getResult());
                result = holder.getResultObject();
                if (errorListener.isError()) {
                    throw errorListener.getException();
                }
                Object var9_9 = null;
                if (transformer == null) return result;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (transformer == null) throw throwable;
                this.transformerPool.returnObject((Object)transformer);
                throw throwable;
            }
            this.transformerPool.returnObject((Object)transformer);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    private StreamSource getStreamSource() throws InitialisationException {
        InputStream is;
        if (this.xslt != null) {
            return new StreamSource(new StringReader(this.xslt));
        }
        if (this.xslFile == null) {
            throw new InitialisationException(new Message(45, (Object)"xslFile"), (Object)this);
        }
        try {
            is = IOUtils.getResourceAsStream((String)this.xslFile, ((Object)((Object)this)).getClass());
        }
        catch (IOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
        if (is != null) {
            return new StreamSource(is);
        }
        throw new InitialisationException(new Message(58, (Object)this.xslFile), (Object)this);
    }

    public Object clone() throws CloneNotSupportedException {
        XsltTransformer x = (XsltTransformer)((Object)super.clone());
        try {
            if (x.nextTransformer == null) {
                x.initialise();
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return x;
    }

    public int getMaxIdleTransformers() {
        return this.maxIdleTransformers;
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.maxIdleTransformers = maxIdleTransformers;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    private class DefaultErrorListener
    implements ErrorListener {
        private TransformerException e = null;
        private UMOTransformer trans;

        public DefaultErrorListener(UMOTransformer trans) {
            this.trans = trans;
        }

        public TransformerException getException() {
            return this.e;
        }

        public boolean isError() {
            return this.e != null;
        }

        public void error(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void fatalError(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.fatal((Object)exception.getMessage());
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void warning(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.warn((Object)exception.getMessage());
        }
    }
}

