/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.io.FilenameUtils;
import org.apache.xmlbeans.impl.common.HttpRetriever;
import org.apache.xmlbeans.impl.schema.StscImporter;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.ws.consumer.MuleWSDLLocatorConfig;
import org.mule.module.ws.consumer.WSConsumer;
import org.mule.module.ws.consumer.WSDLUtils;
import org.mule.module.ws.consumer.wsdl.strategy.factory.HttpRequesterWsdlRetrieverStrategyFactory;
import org.mule.module.ws.consumer.wsdl.strategy.factory.URLWSDLRetrieverStrategyFactory;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class MuleWSDLLocator
implements WSDLLocator,
HttpRetriever {
    private static final Logger logger = LoggerFactory.getLogger(WSConsumer.class);
    public static final String JAR = "jar";
    public static final String ZIP = "zip";
    private String baseURL;
    private String latestImportedURL;
    private boolean useConnectorToRetrieveWsdl;
    private Collection<InputStream> streams = new ArrayList<InputStream>();
    private TlsContextFactory tlsContextFactory;
    private ProxyConfig proxyConfig;
    private MuleContext muleContext;

    public MuleWSDLLocator(MuleWSDLLocatorConfig config) throws MuleException {
        this.baseURL = this.getAbsoluteURL(config.getBaseURI());
        this.useConnectorToRetrieveWsdl = config.isUseConnectorToRetrieveWsdl();
        this.tlsContextFactory = config.getTlsContextFactory();
        this.muleContext = config.getContext();
        this.proxyConfig = config.getProxyConfig();
    }

    public InputSource getBaseInputSource() {
        try {
            return this.getInputSource(this.baseURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        try {
            URL url;
            this.latestImportedURL = this.isHttpAddress(importLocation) ? importLocation : (this.mustResolveRelativePaths(url = IOUtils.getResourceAsUrl((String)parentLocation, this.getClass())) ? StscImporter.resolveRelativePathInArchives((String)(FilenameUtils.normalize((String)WSDLUtils.getBasePath(url.toString())) + importLocation)) : FilenameUtils.normalize((String)(WSDLUtils.getBasePath(url.toString()) + importLocation)));
            return this.getInputSource(this.latestImportedURL);
        }
        catch (Exception e) {
            throw new RuntimeException("There has been an error retrieving the following wsdl resource: " + this.latestImportedURL, e);
        }
    }

    private boolean mustResolveRelativePaths(URL url) {
        return url.getProtocol().equals(JAR) || url.getProtocol().equals(ZIP);
    }

    private InputSource getInputSource(String url) throws WSDLException {
        InputStream resultStream;
        try {
            resultStream = this.getStreamFrom(url);
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", e.getMessage(), (Throwable)e);
        }
        this.streams.add(resultStream);
        return new InputSource(resultStream);
    }

    public String getBaseURI() {
        return this.baseURL;
    }

    public String getLatestImportURI() {
        return this.latestImportedURL;
    }

    public void close() {
        this.closeStreams();
    }

    private void closeStreams() {
        for (InputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.warn("Error closing stream during WSDL retrieval");
            }
        }
    }

    private boolean isHttpAddress(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }

    public InputStream getStreamFrom(String url) throws Exception {
        boolean isHttpRequester = this.isHttpAddress(url);
        InputStream resultStream = null;
        resultStream = this.useConnectorToRetrieveWsdl && isHttpRequester ? new HttpRequesterWsdlRetrieverStrategyFactory(this.tlsContextFactory, this.proxyConfig, this.muleContext).createWSDLRetrieverStrategy().retrieveWsdlResource(url) : new URLWSDLRetrieverStrategyFactory().createWSDLRetrieverStrategy().retrieveWsdlResource(url);
        return resultStream;
    }

    private String getAbsoluteURL(String uri) {
        if (uri != null) {
            URL absoluteURL = IOUtils.getResourceAsUrl((String)uri, this.getClass());
            return absoluteURL == null ? null : absoluteURL.toString();
        }
        return uri;
    }
}

