/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.construct.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.Transformer;
import org.mule.construct.builder.AbstractFlowConstructWithSingleInboundAndOutboundEndpointBuilder;
import org.mule.module.ws.construct.WSProxy;
import org.mule.util.FileUtils;

public class WSProxyBuilder
extends AbstractFlowConstructWithSingleInboundAndOutboundEndpointBuilder<WSProxyBuilder, WSProxy> {
    protected URI wsldLocation;
    protected File wsdlFile;

    protected MessageExchangePattern getInboundMessageExchangePattern() {
        return MessageExchangePattern.REQUEST_RESPONSE;
    }

    protected MessageExchangePattern getOutboundMessageExchangePattern() {
        return MessageExchangePattern.REQUEST_RESPONSE;
    }

    public WSProxyBuilder transformers(Transformer ... outboundTransformers) {
        this.transformers = Arrays.asList((MessageProcessor[])outboundTransformers);
        return this;
    }

    public WSProxyBuilder responseTransformers(Transformer ... outboundResponseTransformers) {
        this.responseTransformers = Arrays.asList((MessageProcessor[])outboundResponseTransformers);
        return this;
    }

    public WSProxyBuilder wsldLocation(URI wsldLocation) {
        this.wsldLocation = wsldLocation;
        return this;
    }

    public WSProxyBuilder wsdlFile(File wsdlFile) {
        this.wsdlFile = wsdlFile;
        return this;
    }

    protected WSProxy buildFlowConstruct(MuleContext muleContext) throws MuleException {
        if (this.wsdlFile != null) {
            return this.buildStaticWsdlContentsWSProxy(muleContext);
        }
        if (this.wsldLocation != null) {
            return this.buildStaticWsdlUriWSProxy(muleContext);
        }
        return this.buildDynamicWsdlUriWSProxy(muleContext);
    }

    private WSProxy buildDynamicWsdlUriWSProxy(MuleContext muleContext) throws MuleException {
        return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext), this.transformers, this.responseTransformers);
    }

    private WSProxy buildStaticWsdlContentsWSProxy(MuleContext muleContext) throws MuleException {
        try {
            return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext), (List<MessageProcessor>)this.transformers, (List<MessageProcessor>)this.responseTransformers, FileUtils.readFileToString((File)this.wsdlFile));
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe);
        }
    }

    private WSProxy buildStaticWsdlUriWSProxy(MuleContext muleContext) throws MuleException {
        return new WSProxy(this.name, muleContext, (MessageSource)this.getOrBuildInboundEndpoint(muleContext), this.getOrBuildOutboundEndpoint(muleContext), (List<MessageProcessor>)this.transformers, (List<MessageProcessor>)this.responseTransformers, this.wsldLocation);
    }
}

