/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.mule.extension.validation.api.ValidationException;
import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.Validator;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ValidationSupport {
    protected static final String ERROR_GROUP = "Error options";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ValidationSupport.class);
    @Inject
    protected MuleContext muleContext;

    ValidationSupport() {
    }

    protected void validateWith(Validator validator, ValidationContext validationContext, Event event) throws Exception {
        ValidationResult result = validator.validate(event);
        if (result.isError()) {
            result = this.evaluateCustomMessage(result, validationContext);
            String customExceptionClass = validationContext.getOptions().getExceptionClass();
            if (StringUtils.isEmpty((String)customExceptionClass)) {
                throw validationContext.getConfig().getExceptionFactory().createException(result, ValidationException.class, event);
            }
            throw validationContext.getConfig().getExceptionFactory().createException(result, customExceptionClass, event);
        }
        this.logSuccessfulValidation(validator, event);
    }

    private ValidationResult evaluateCustomMessage(ValidationResult result, ValidationContext validationContext) {
        String customMessage = validationContext.getOptions().getMessage();
        return StringUtils.isBlank((String)customMessage) ? result : ImmutableValidationResult.error(customMessage);
    }

    protected ValidationContext createContext(ValidationOptions options, Event muleEvent, ValidationExtension config) {
        return new ValidationContext(options, muleEvent, config);
    }

    protected Locale parseLocale(String locale) {
        locale = StringUtils.isBlank((String)locale) ? ValidationExtension.DEFAULT_LOCALE : locale;
        return new Locale(locale);
    }

    protected void logSuccessfulValidation(Validator validator, Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully executed validator {}", (Object)ToStringBuilder.reflectionToString((Object)validator));
        }
    }
}

