/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.mule.extension.validation.api.ExceptionFactory;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.CollectionUtils;
import org.reflections.ReflectionUtils;

public class DefaultExceptionFactory
implements ExceptionFactory {
    private final LoadingCache<Class<? extends Exception>, ConstructorDelegate<? extends Exception>> constructorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends Exception>, ConstructorDelegate<? extends Exception>>(){

        public ConstructorDelegate<? extends Exception> load(Class<? extends Exception> exceptionType) throws Exception {
            return DefaultExceptionFactory.this.selectMostCompleteConstructor(exceptionType);
        }
    });
    private final LoadingCache<String, Class<? extends Exception>> classCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Class<? extends Exception>>(){

        public Class<? extends Exception> load(String exceptionClassName) throws Exception {
            Class exceptionClass;
            try {
                exceptionClass = ClassUtils.getClass((String)exceptionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find exception class " + exceptionClassName);
            }
            if (!Exception.class.isAssignableFrom(exceptionClass)) {
                throw new IllegalArgumentException(String.format("Was expecting an exception type, %s found instead", exceptionClass.getCanonicalName()));
            }
            return exceptionClass;
        }
    });

    @Override
    public <T extends Exception> T createException(ValidationResult result, Class<T> exceptionClass, Event event) {
        ConstructorDelegate<? extends Exception> constructorDelegate = this.get(this.constructorCache, exceptionClass);
        try {
            return (T)constructorDelegate.createException(result, result.getMessage(), event);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create exception of type %s. Exception message was:\n%s", exceptionClass.getName(), result.getMessage())));
        }
    }

    @Override
    public Exception createException(ValidationResult result, String exceptionClassName, Event event) {
        return this.createException(result, this.get(this.classCache, exceptionClassName), event);
    }

    private <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private <T extends Exception> ConstructorDelegate<T> selectMostCompleteConstructor(Class<T> exceptionType) {
        Set candidate = ReflectionUtils.getConstructors(exceptionType, (Predicate[])new Predicate[]{ReflectionUtils.withParameters((Class[])new Class[]{ValidationResult.class, Event.class})});
        if (!CollectionUtils.isEmpty((Collection)candidate)) {
            return new ValidationResultAndEventConstructorDelegate((Constructor)candidate.iterator().next());
        }
        candidate = ReflectionUtils.getConstructors(exceptionType, (Predicate[])new Predicate[]{ReflectionUtils.withParameters((Class[])new Class[]{ValidationResult.class})});
        if (!CollectionUtils.isEmpty((Collection)candidate)) {
            return new ValidationResultConstructorDelegate((Constructor)candidate.iterator().next());
        }
        candidate = ReflectionUtils.getConstructors(exceptionType, (Predicate[])new Predicate[]{ReflectionUtils.withParameters((Class[])new Class[]{String.class})});
        if (CollectionUtils.isEmpty((Collection)candidate)) {
            throw new IllegalArgumentException(String.format("Exception type %s was expected to contain at least one accessible constructor with eia single String argument but a matching constructor could not be found.", exceptionType.getCanonicalName()));
        }
        return new DirectMessageConstructorDelegate((Constructor)candidate.iterator().next());
    }

    private class DirectMessageConstructorDelegate<T extends Exception>
    implements ConstructorDelegate<T> {
        private final Constructor<T> constructor;

        public DirectMessageConstructorDelegate(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T createException(ValidationResult validationResult, String message, Event event) throws Exception {
            return (T)((Exception)this.constructor.newInstance(message));
        }
    }

    private class ValidationResultConstructorDelegate<T extends Exception>
    implements ConstructorDelegate<T> {
        private final Constructor<T> constructor;

        private ValidationResultConstructorDelegate(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T createException(ValidationResult validationResult, String message, Event event) throws Exception {
            return (T)((Exception)this.constructor.newInstance(validationResult));
        }
    }

    private class ValidationResultAndEventConstructorDelegate<T extends Exception>
    implements ConstructorDelegate<T> {
        private final Constructor<T> constructor;

        public ValidationResultAndEventConstructorDelegate(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T createException(ValidationResult validationResult, String message, Event event) throws Exception {
            return (T)((Exception)this.constructor.newInstance(validationResult, event));
        }
    }

    private static interface ConstructorDelegate<T extends Exception> {
        public T createException(ValidationResult var1, String var2, Event var3) throws Exception;
    }
}

